package com.flybits.commons.library.api;

import android.content.Context;
import android.support.annotation.NonNull;

import com.flybits.commons.library.analytics.AnalyticsBundle;
import com.flybits.commons.library.analytics.UploadChannel;
import com.flybits.commons.library.analytics.converter.JsonConverter;
import com.flybits.commons.library.exceptions.FlybitsDisabledException;
import com.flybits.commons.library.http.HttpDefaultClass;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

class FlybitsUploadChannel implements UploadChannel {

    private final static String _TAG        = "Analytics:Upload";
    private final String HOST_URL    = "https://justin.zonesworld.com/analyticsstore";
    private String sessionKey = null;

    @Override
    public String getName() { return "FLYBITS_MAIN"; }

    @Override
    public boolean onInit(@NonNull Context context) {
        try {
            Result result = new HttpDefaultClass.Builder(context, false, HOST_URL + String.format("/session?key=%s", "ih47h467kk85ghee"))
                    .get().getResponse();

            if (result.getStatus() == RequestStatus.COMPLETED) {
                try {
                    JSONObject authResultObj = new JSONObject(result.getResultAsString());
                    sessionKey = authResultObj.getString("key");
                } catch (JSONException e) {
                    Logger.exception("FlybitsUploadChannel.onInit", e);
                    Logger.setTag(_TAG).e("Flybits upload channel had an error while initing.");
                    return false;
                }
            }
            return result.getStatus() == RequestStatus.COMPLETED;
        } catch (FlybitsDisabledException | IOException | NullPointerException e) {
            Logger.exception("FlybitsUploadChannel.onInit", e);
            Logger.setTag(_TAG).d("Could not init the Flybits upload channel.");
            return false;
        }
    }

    @Override
    public boolean onUpload(@NonNull Context context, @NonNull String deviceId, @NonNull String projectID, @NonNull AnalyticsBundle[] bundles) {

        JsonConverter converter = new JsonConverter();

        try {
            String dataJson = converter.to(bundles);
            JSONArray dataJsonObject = new JSONArray(dataJson);

            HashMap<String, String> headers = new LinkedHashMap<>();
            headers.put("key", sessionKey);
            headers.put("appid", projectID);

            JSONObject reportRequest = new JSONObject();
            reportRequest.put("deviceID", deviceId);
            reportRequest.put("data", dataJsonObject);

            String reportRequestAsJSON = reportRequest.toString();

            Result result   = new HttpDefaultClass.Builder(context, false, HOST_URL + "/events")
                    .addHeaders(headers)
                    .post(reportRequestAsJSON).getResponse();
            return result.getStatus() == RequestStatus.COMPLETED;
        } catch (FlybitsDisabledException | JSONException | IOException | NullPointerException e) {
            Logger.exception("FlybitsUploadChannel.onUpload", e);
            Logger.setTag(_TAG).e("Could not upload on the Flybits upload channel.");
            return false;
        }
    }

    public boolean isAuthed()
    {
        return sessionKey != null;
    }

}
