/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import com.flybits.commons.library.api.results.QueryStatus;
import com.flybits.commons.library.exceptions.FlybitsException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

abstract class FlybitsResult {
    private ScheduledExecutorService sched;
    private ScheduledFuture<?> scheduledFuture;
    private Context context;
    private ExecutorService service;
    private QueryStatus status;
    private Runnable r = new Runnable(){

        @Override
        public void run() {
            if (FlybitsResult.this.status == QueryStatus.PROCESSING) {
                FlybitsResult.this.status = QueryStatus.TIMED_OUT;
                FlybitsResult.this.cancelRequest();
                FlybitsResult.this.cancelTimeout();
            }
        }
    };

    public FlybitsResult(Context context) {
        this.context = context;
        this.status = QueryStatus.INITIALIZED;
        this.sched = Executors.newScheduledThreadPool(1);
    }

    public FlybitsResult(Context context, ExecutorService service) {
        this(context);
        this.setService(service);
    }

    public void cancel() {
        if (this.status == QueryStatus.PROCESSING) {
            this.status = QueryStatus.CANCELLED;
            this.cancelRequest();
        }
        this.cancelTimeout();
    }

    public Context getContext() {
        return this.context;
    }

    public ExecutorService getService() {
        return this.service;
    }

    public QueryStatus getStatus() {
        return this.status;
    }

    protected boolean setFailed(FlybitsException e) {
        if (this.getStatus() != QueryStatus.CANCELLED && this.getStatus() != QueryStatus.TIMED_OUT) {
            this.status = QueryStatus.FAILED;
            this.cancelTimeout();
            this.cancelRequest();
            return true;
        }
        return false;
    }

    public void setService(ExecutorService service) {
        this.service = service;
        this.status = QueryStatus.PROCESSING;
    }

    protected boolean setSuccess() {
        if (this.getStatus() != QueryStatus.CANCELLED && this.getStatus() != QueryStatus.TIMED_OUT) {
            this.status = QueryStatus.SUCCESS;
            this.cancelTimeout();
            this.cancelRequest();
            return true;
        }
        return false;
    }

    public void setTimeout(long time, TimeUnit unit) {
        this.scheduledFuture = this.sched.schedule(this.r, time, unit);
    }

    private void cancelRequest() {
        if (this.service != null && !this.service.isShutdown()) {
            this.service.shutdownNow();
        }
    }

    private void cancelTimeout() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }
}

