/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.caching;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.CachingEntry;
import java.util.ArrayList;
import java.util.List;

public abstract class FlybitsUIListObserver<T> {
    private DataChanged<T> callback;
    private LiveData<List<T>> item;
    private Observer<List<T>> observer;
    private List<T> itemsLoaded;
    private Context context;

    public FlybitsUIListObserver(@NonNull Context context) {
        this.context = context;
        this.itemsLoaded = new ArrayList<T>();
    }

    protected void add(final @NonNull String key, DataChanged<T> callback) {
        this.callback = callback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                List<CachingEntry> listOfCacheObjects = CommonsDatabase.getDatabase(FlybitsUIListObserver.this.context).cachingEntryDAO().getByKey(key);
                ArrayList<String> ids = new ArrayList<String>();
                for (CachingEntry entry : listOfCacheObjects) {
                    ids.add(entry.getContentId());
                }
                FlybitsUIListObserver.this.onLoad(ids);
            }
        }).start();
    }

    protected Context getContext() {
        return this.context;
    }

    @Nullable
    public LiveData<List<T>> getData() {
        return this.item;
    }

    protected abstract void onLoad(List<String> var1);

    public void remove() {
        if (this.item != null && this.item.hasActiveObservers()) {
            this.item.removeObserver(this.observer);
        }
    }

    public List<T> getItems() {
        return this.itemsLoaded;
    }

    protected void setItems(@NonNull LiveData<List<T>> item) {
        this.item = item;
        this.observer = new Observer<List<T>>(){

            public void onChanged(@Nullable List<T> items) {
                if (FlybitsUIListObserver.this.callback != null) {
                    FlybitsUIListObserver.this.callback.onLoad(items);
                }
            }
        };
        this.item.observeForever(this.observer);
    }

    public static interface DataChanged<T> {
        public void onLoad(List<T> var1);
    }
}

