package com.flybits.commons.library.analytics;

import android.content.Context;

/**
 * The {@code UploadChannel} interface sets the necessary callbacks to upload analytics data to a
 * server.
 */
public interface UploadChannel {

    /**
     * The unique name of this upload channel.
     * @return A unique name.
     */
    String getName();

    /**
     * Called before uploading begins. This is used to setup any authentication that may be needed
     * before data can be uploaded.
     *
     * @param context A {@link Context} is provided for HTTP access.
     * @return True if the server returned a success response, otherwise false.
     */
    boolean onInit(Context context);

    /**
     * Called whenever analytic data has to be flushed.
     *
     * @param context A {@link Context} is provided for HTTP access.
     * @param deviceId A unique id that describes this device. It either comes from a custom id, a
     *                 Flybits id, or the device id itself (in that order).
     * @param appID Unique identifier that indicates which application the analytics should be
     *              characterized under.
     * @param bundles An array of {@link AnalyticsBundle} objects that contain the events to be
     *                flushed.
     * @return True if the server returned a success response, otherwise false.
     */
    boolean onUpload(Context context, String deviceId, String appID, AnalyticsBundle[] bundles);

}
