/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.idps;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.flybits.commons.library.api.idps.IDP;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

public class SignedIDP
extends IDP {
    private static final String AUTHENTICATE_ENDPOINT = "/signedLogin";
    private String accessToken;
    private String signature;
    public static final Parcelable.Creator<SignedIDP> CREATOR = new Parcelable.Creator<SignedIDP>(){

        public SignedIDP createFromParcel(Parcel in) {
            return new SignedIDP(in);
        }

        public SignedIDP[] newArray(int size) {
            return new SignedIDP[size];
        }
    };

    private SignedIDP(Parcel in) {
        super(in);
        this.accessToken = in.readString();
        this.signature = in.readString();
    }

    public SignedIDP(String accessToken, String signature) {
        super("signedLogin");
        this.accessToken = accessToken;
        this.signature = signature;
    }

    @Override
    public String getAuthenticationEndPoint() {
        return AUTHENTICATE_ENDPOINT;
    }

    @Override
    public JSONObject getBody() {
        JSONObject bodyObject = new JSONObject();
        try {
            bodyObject.put("accessToken", (Object)this.accessToken);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            bodyObject.put("signature", (Object)this.signature);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return bodyObject;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeString(this.accessToken);
        out.writeString(this.signature);
    }

    public static String base64Encode(Context context, String email) {
        JSONObject bodyObject = new JSONObject();
        try {
            bodyObject.put("projectId", (Object)SignedIDP.getProjectID(context));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            bodyObject.put("email", (Object)email);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            String body = bodyObject.toString();
            byte[] data = body.getBytes("UTF-8");
            return Base64.encodeToString((byte[])data, (int)2);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }
}

