package com.flybits.internal.db;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;

import com.flybits.internal.db.models.CachingEntry;

import java.util.List;

@Dao
public interface CachingEntryDAO {

    @Query("SELECT * FROM cachingentry")
    LiveData<List<CachingEntry>> getLive();

    @Query("SELECT * FROM cachingentry")
    List<CachingEntry> getAll();

    @Query("SELECT * FROM cachingentry WHERE cachingkey = :key")
    LiveData<List<CachingEntry>> getLive(String key);

    @Query("SELECT contentID FROM cachingentry WHERE cachingkey = :key")
    List<String> getIdsByCachingKey(String key);

    @Query("SELECT * FROM cachingentry WHERE cachingkey = :key")
    List<CachingEntry> getByKey(String key);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(CachingEntry entry);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(List<CachingEntry> entry);

    @Query("Delete from cachingentry")
    void clear();

    @Query("Delete from cachingentry WHERE cachingkey = :key")
    void deleteAllByCachingKey(String key);
}
