package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.UserPreferences;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeUserPref<T extends UserPreferences> extends IDeserializer<T>{

    private T classObject;

    public DeserializeUserPref(Class<T> newClass){
        try {
            classObject = newClass.newInstance();
        }catch (IllegalAccessException e){
            throw new RuntimeException("This is a test");
        }catch (InstantiationException e2){
            throw new RuntimeException("This is a test2: " + e2);
        }
    }

    @Override
    public String toJson(T obj) {
        JSONObject jsonObject   = new JSONObject();
        try{
            jsonObject.put("data", obj.toJSON());
        }catch (JSONException ex){}

        return jsonObject.toString();
    }

    @Override
    public T fromJson(JSONObject jObj) {
        try {
            if (!jObj.isNull("data")) {

                JSONObject object = jObj.getJSONObject("data");
                classObject.fromJSON(object.toString());
                return (T) classObject;
            }
        } catch (JSONException e) {
            Logger.exception("DeserializeLogin.fromJson", e);
        }
        return null;
    }

    @Override
    public T fromJson(JSONArray jsonObject) {
        return null;
    }
}