package com.flybits.commons.library.caching;

import android.app.Activity;
import android.content.Context;

import com.flybits.commons.library.models.User;
import com.flybits.internal.db.CommonsDatabase;

import java.util.ArrayList;
import java.util.List;

/**
 * The {@code UserCacheLoader} is responsible for loading cached data associated to a
 * {@link com.flybits.commons.library.models.User}. This data is inserted into the local SQLite DB
 * whenever {@link com.flybits.commons.library.models.User} data is received from the Flybits server.
 */
public class UserCacheLoader extends FlybitsCacheLoader<User> {

    @Deprecated
    public UserCacheLoader(Context context){
        super(context);
    }

    public UserCacheLoader(Activity activity){
        super(activity);
    }

    @Override
    protected List<User> load(List<String> cachedIds) {
        List<User> listOfUsers = new ArrayList<>();
        listOfUsers.add(CommonsDatabase.getDatabase(getContext()).userDao().getSingle());
        return listOfUsers;
    }

    @Override
    protected User load(String id) {
        return CommonsDatabase.getDatabase(getContext()).userDao().getSingle();
    }

    public UserCacheLoader get(final CacheObjectLoader<User> callback){
        super.getItem(null, callback);
        return this;
    }
}
