/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models.internal;

import com.flybits.commons.library.models.internal.OrderBy;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.SortByEnumeratable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QueryParameters {
    private long limit;
    private long offset;
    private ArrayList<String> labels;
    private OrderBy orderBy = null;
    private SortByEnumeratable sortBy = null;
    private String cachingKey;
    private int cachingLimit;

    public QueryParameters(QueryBuilder builder) {
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.labels = builder.labels;
        this.sortBy = builder.sortBy;
        this.orderBy = builder.orderBy;
        this.cachingKey = builder.cachingKey;
        this.cachingLimit = builder.cachingLimit;
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        if (this.limit > 0L && this.offset > -1L) {
            ArrayList<String> limitParam = new ArrayList<String>();
            limitParam.add(String.valueOf(this.limit));
            params.put("limit", limitParam);
            ArrayList<String> offsetParam = new ArrayList<String>();
            offsetParam.add(String.valueOf(this.offset));
            params.put("offset", offsetParam);
        }
        if (this.labels.size() > 0) {
            ArrayList<String> labelsParam = new ArrayList<String>();
            labelsParam.addAll(this.labels);
            params.put("labels", labelsParam);
        }
        if (this.sortBy != null && this.orderBy != null) {
            ArrayList<String> sortByParam = new ArrayList<String>();
            ArrayList<String> orderByParam = new ArrayList<String>();
            sortByParam.add(this.sortBy.getValue());
            orderByParam.add(this.orderBy.toString());
            params.put("sortby", sortByParam);
            params.put("sortorder", orderByParam);
        }
        return params;
    }

    public String getCachingKey() {
        return this.cachingKey;
    }

    public int getCachingLimit() {
        return this.cachingLimit;
    }

    public long getLimit() {
        return this.limit;
    }

    public ArrayList<String> getLabels() {
        return this.labels;
    }

    public long getOffset() {
        return this.offset;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public SortByEnumeratable getSortBy() {
        return this.sortBy;
    }

    public void setPaging(long limit, long offset) {
        this.limit = limit;
        this.offset = offset;
    }
}

