package com.flybits.internal.db.models;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.support.annotation.NonNull;

@Entity(tableName = "cachingentry", primaryKeys = {"cachingkey", "contentID"})
public class CachingEntry {

    @ColumnInfo(name = "cachingkey")
    @NonNull
    private String cachingKey;

    @ColumnInfo(name = "contentID")
    @NonNull
    private String contentId;

    public CachingEntry (){}

    @Ignore
    public CachingEntry (@NonNull String cachingKey, @NonNull String contentId){
        this.cachingKey     = cachingKey;
        this.contentId      = contentId;
    }

    public String getCachingKey() {
        return cachingKey;
    }

    public void setCachingKey(String cachingKey) {
        this.cachingKey = cachingKey;
    }

    public String getContentId() {
        return contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CachingEntry that = (CachingEntry) o;

        return that.contentId.equalsIgnoreCase(contentId)
                && that.cachingKey.equalsIgnoreCase(cachingKey);
    }
}
