package com.flybits.commons.library.analytics.converter;


import com.flybits.commons.library.analytics.AnalyticsBundle;

/**
 * The {@code Converter} interface sets the necessary callbacks to serialize/deserialize
 * {@link AnalyticsBundle} data * to some other format.
 */
public interface Converter<T> {

    /**
     * Converts an array of {@link AnalyticsBundle} objects to something else.
     * @param bundle An array of {@link AnalyticsBundle} objects.
     * @return The type object returned by this converter.
     * @throws Exception Throws an exception if there was an error converting.
     */
    T to(AnalyticsBundle[] bundle) throws Exception;

    /**
     * Converts a object of any type to an array of {@link AnalyticsBundle} objects.
     * @param data The data to convert.
     * @return An array of {@link AnalyticsBundle} objects that the data contained.
     * @throws Exception Throws an exception if there was an error converting.
     */
    AnalyticsBundle[] from(T data) throws Exception;
}
