package com.flybits.commons.library.api.results;

/**
 * The status that indicates the state of the network request that is used to retrieve the
 * items.
 */
public enum QueryStatus {
    /**
     * Indicates that the latest query request was cancelled manually by the application. This
     * occurs when the application manually calls the {@code cancel()} method.
     */
    CANCELLED,

    /**
     * Indicates that the retrieval of the next set of results has failed due an error reported
     * by the Flybits server. This occurs when the SDK calls the
     * {@code setFailed(FlybitsException)} method.
     */
    FAILED,

    /**
     * Indicates that the {@code PagedResult} has been initialized.
     */
    INITIALIZED,

    /**
     * Indicates that the network request to get the next set of items is currently being
     * processed.
     */
    PROCESSING,

    /**
     * Indicates that the network request was successfully completed and the new set of items
     * was retrieved.
     */
    SUCCESS,

    /**
     * Indicates that the request has timed out as per the timeout set but the application.
     */
    TIMED_OUT
}
