/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.flybits.internal.db.CachingEntryDAO;
import com.flybits.internal.db.models.CachingEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CachingEntryDAO_Impl
implements CachingEntryDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfCachingEntry;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllByKey;

    public CachingEntryDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCachingEntry = new EntityInsertionAdapter<CachingEntry>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `cachingentry`(`cachingkey`,`contentID`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CachingEntry value) {
                if (value.getCachingKey() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCachingKey());
                }
                if (value.getContentId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getContentId());
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from cachingentry";
                return "Delete from cachingentry";
            }
        };
        this.__preparedStmtOfDeleteAllByKey = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from cachingentry WHERE cachingkey = ?";
                return "Delete from cachingentry WHERE cachingkey = ?";
            }
        };
    }

    @Override
    public void insert(CachingEntry entry) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCachingEntry.insert((Object)entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<CachingEntry> entry) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCachingEntry.insert(entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllByKey(String key) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllByKey.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (key == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, key);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllByKey.release(_stmt);
        }
    }

    @Override
    public LiveData<List<CachingEntry>> getLive() {
        String _sql = "SELECT * FROM cachingentry";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM cachingentry", (int)0);
        return new ComputableLiveData<List<CachingEntry>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<CachingEntry> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("cachingentry", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    CachingEntryDAO_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = CachingEntryDAO_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfCachingKey = _cursor.getColumnIndexOrThrow("cachingkey");
                    int _cursorIndexOfContentId = _cursor.getColumnIndexOrThrow("contentID");
                    ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CachingEntry _item = new CachingEntry();
                        String _tmpCachingKey = _cursor.getString(_cursorIndexOfCachingKey);
                        _item.setCachingKey(_tmpCachingKey);
                        String _tmpContentId = _cursor.getString(_cursorIndexOfContentId);
                        _item.setContentId(_tmpContentId);
                        _result.add(_item);
                    }
                    ArrayList<CachingEntry> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CachingEntry> getAll() {
        String _sql = "SELECT * FROM cachingentry";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM cachingentry", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfCachingKey = _cursor.getColumnIndexOrThrow("cachingkey");
            int _cursorIndexOfContentId = _cursor.getColumnIndexOrThrow("contentID");
            ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CachingEntry _item = new CachingEntry();
                String _tmpCachingKey = _cursor.getString(_cursorIndexOfCachingKey);
                _item.setCachingKey(_tmpCachingKey);
                String _tmpContentId = _cursor.getString(_cursorIndexOfContentId);
                _item.setContentId(_tmpContentId);
                _result.add(_item);
            }
            ArrayList<CachingEntry> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<CachingEntry>> getLive(String key) {
        String _sql = "SELECT * FROM cachingentry WHERE cachingkey = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM cachingentry WHERE cachingkey = ?", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        return new ComputableLiveData<List<CachingEntry>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<CachingEntry> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("cachingentry", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    CachingEntryDAO_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = CachingEntryDAO_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfCachingKey = _cursor.getColumnIndexOrThrow("cachingkey");
                    int _cursorIndexOfContentId = _cursor.getColumnIndexOrThrow("contentID");
                    ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CachingEntry _item = new CachingEntry();
                        String _tmpCachingKey = _cursor.getString(_cursorIndexOfCachingKey);
                        _item.setCachingKey(_tmpCachingKey);
                        String _tmpContentId = _cursor.getString(_cursorIndexOfContentId);
                        _item.setContentId(_tmpContentId);
                        _result.add(_item);
                    }
                    ArrayList<CachingEntry> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CachingEntry> getByKey(String key) {
        String _sql = "SELECT * FROM cachingentry WHERE cachingkey = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM cachingentry WHERE cachingkey = ?", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfCachingKey = _cursor.getColumnIndexOrThrow("cachingkey");
            int _cursorIndexOfContentId = _cursor.getColumnIndexOrThrow("contentID");
            ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CachingEntry _item = new CachingEntry();
                String _tmpCachingKey = _cursor.getString(_cursorIndexOfCachingKey);
                _item.setCachingKey(_tmpCachingKey);
                String _tmpContentId = _cursor.getString(_cursorIndexOfContentId);
                _item.setContentId(_tmpContentId);
                _result.add(_item);
            }
            ArrayList<CachingEntry> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

