/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.caching;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.CachingEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class FlybitsCacheLoader<T> {
    private CacheLoader callback;
    private ExecutorService executorService;
    private Context context;

    public FlybitsCacheLoader(@NonNull Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public abstract List<T> load(List<String> var1);

    public void get(final @NonNull String cachingKey, final CacheLoader<T> callback) {
        this.callback = callback;
        final Handler handler = new Handler(Looper.getMainLooper());
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                List<CachingEntry> listOfCacheObjects = CommonsDatabase.getDatabase(FlybitsCacheLoader.this.context).cachingEntryDAO().getByKey(cachingKey);
                ArrayList<String> ids = new ArrayList<String>();
                for (CachingEntry entry : listOfCacheObjects) {
                    ids.add(entry.getContentId());
                }
                final List loadedList = FlybitsCacheLoader.this.load(ids);
                if (callback != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (loadedList != null) {
                                callback.onLoad(loadedList);
                            } else {
                                callback.onLoad(new ArrayList());
                            }
                        }
                    });
                }
            }
        });
    }

    public void cancel() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
            if (this.callback != null) {
                this.callback.onCancel();
            }
        }
    }

    public static interface CacheLoader<T> {
        public void onCancel();

        public void onLoad(List<T> var1);
    }
}

