package com.flybits.internal.db;

import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.content.Context;

import com.flybits.commons.library.models.User;
import com.flybits.internal.db.models.CachingEntry;

@Database(entities = {User.class, CachingEntry.class}, version = 2)
public abstract class CommonsDatabase extends RoomDatabase {

    private static CommonsDatabase INSTANCE;

    public abstract UserDAO userDao();
    public abstract CachingEntryDAO cachingEntryDAO();

    public static CommonsDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE =
                    Room.databaseBuilder(context, CommonsDatabase.class, "commons-flybits-db")
                            .build();
                   /*
                    Room.inMemoryDatabaseBuilder(context.getApplicationContext(), ContextDatabase.class)
                            // To simplify the codelab, allow queries on the main thread.
                            // Don't do this on a real app! See PersistenceBasicSample for an example.
                            .allowMainThreadQueries()
                            .build();
                    */
        }
        return INSTANCE;
    }

    public static void destroyInstance() {
        INSTANCE = null;
    }
}
