package com.flybits.commons.library.analytics.storage.sql;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import com.flybits.commons.library.analytics.AnalyticsBundle;
import com.flybits.commons.library.analytics.storage.QueueStorage;

/**
 * A Sqlite database implementation of {@link QueueStorage}.
 */
public class SqliteStorage implements QueueStorage {

    Context mContext;

    public SqliteStorage(Context context)
    {
        mContext = context;
    }

    /**
     * Adds a serialized {@link AnalyticsBundle} to the SqliteStorage queue.
     * @param bundle The bundle to be queued up.
     */
    @Override
    public void add(AnalyticsBundle bundle) {
        AnalyticsQueueStorageHelper helper      = AnalyticsQueueStorageHelper.getInstance(mContext);
        SQLiteDatabase db                       = helper.getWritableDatabase();
        helper.add(db, bundle);
    }

    /**
     * Gets the next {@link AnalyticsBundle} from the SqliteStorage queue.
     * @return The next {@link AnalyticsBundle} in the queue.
     */
    @Override
    public AnalyticsBundle getNext() {
        AnalyticsQueueStorageHelper helper    = AnalyticsQueueStorageHelper.getInstance(mContext);
        SQLiteDatabase db               = helper.getWritableDatabase();
        return helper.getNext(db);
    }

    /**
     * Gets all the next {@link AnalyticsBundle}s from the SqliteStorage queue.
     * @return A list of {@link AnalyticsBundle}s sorted by order retrieved from the queue.
     */
    @Override
    public AnalyticsBundle[] getAll() {
        AnalyticsQueueStorageHelper helper    = AnalyticsQueueStorageHelper.getInstance(mContext);
        SQLiteDatabase db               = helper.getWritableDatabase();
        return helper.getAll(db);
    }

    /**
     * Removes {@link AnalyticsBundle}s from the SqliteStorage queue, up to count.
     */
    @Override
    public void remove(int count) {
        AnalyticsQueueStorageHelper helper    = AnalyticsQueueStorageHelper.getInstance(mContext);
        SQLiteDatabase db               = helper.getWritableDatabase();
        helper.remove(db, count);
    }

    /**
     * Gets the amount of {@link AnalyticsBundle}s in the SqliteStorage queue.
     * @return The amount of queued {@link AnalyticsBundle}s.
     */
    @Override
    public int size() {
        AnalyticsQueueStorageHelper helper    = AnalyticsQueueStorageHelper.getInstance(mContext);
        SQLiteDatabase db               = helper.getWritableDatabase();
        return helper.getSize(db);
    }

}
