/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.commons.library.analytics.AnalyticsBundle;
import com.flybits.commons.library.analytics.UploadChannel;
import com.flybits.commons.library.analytics.converter.JsonConverter;
import com.flybits.commons.library.exceptions.FlybitsDisabledException;
import com.flybits.commons.library.http.HttpDefaultClass;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class FlybitsUploadChannel
implements UploadChannel {
    private static final String _TAG = "Analytics:Upload";
    private final String HOST_URL = "https://justin.zonesworld.com/analyticsstore";
    private String sessionKey = null;

    FlybitsUploadChannel() {
    }

    @Override
    public String getName() {
        return "FLYBITS_MAIN";
    }

    @Override
    public boolean onInit(@NonNull Context context) {
        try {
            Result result = new HttpDefaultClass.Builder(context, false, "https://justin.zonesworld.com/analyticsstore" + String.format("/session?key=%s", "ih47h467kk85ghee")).get().getResponse();
            if (result.getStatus() == RequestStatus.COMPLETED) {
                try {
                    JSONObject authResultObj = new JSONObject(result.getResultAsString());
                    this.sessionKey = authResultObj.getString("key");
                }
                catch (JSONException e) {
                    Logger.exception("FlybitsUploadChannel.onInit", (Exception)((Object)e));
                    Logger.setTag(_TAG).e("Flybits upload channel had an error while initing.");
                    return false;
                }
            }
            return result.getStatus() == RequestStatus.COMPLETED;
        }
        catch (FlybitsDisabledException | IOException | NullPointerException e) {
            Logger.exception("FlybitsUploadChannel.onInit", e);
            Logger.setTag(_TAG).d("Could not init the Flybits upload channel.");
            return false;
        }
    }

    @Override
    public boolean onUpload(@NonNull Context context, @NonNull String deviceId, @NonNull String projectID, @NonNull AnalyticsBundle[] bundles) {
        JsonConverter converter = new JsonConverter();
        try {
            String dataJson = converter.to(bundles);
            JSONArray dataJsonObject = new JSONArray(dataJson);
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            headers.put("key", this.sessionKey);
            headers.put("appid", projectID);
            JSONObject reportRequest = new JSONObject();
            reportRequest.put("deviceID", (Object)deviceId);
            reportRequest.put("data", (Object)dataJsonObject);
            String reportRequestAsJSON = reportRequest.toString();
            Result result = new HttpDefaultClass.Builder(context, false, "https://justin.zonesworld.com/analyticsstore/events").addHeaders(headers).post(reportRequestAsJSON).getResponse();
            return result.getStatus() == RequestStatus.COMPLETED;
        }
        catch (FlybitsDisabledException | IOException | NullPointerException | JSONException e) {
            Logger.exception("FlybitsUploadChannel.onUpload", (Exception)e);
            Logger.setTag(_TAG).e("Could not upload on the Flybits upload channel.");
            return false;
        }
    }

    public boolean isAuthed() {
        return this.sessionKey != null;
    }
}

