package com.flybits.commons.library.caching;

import android.content.Context;

import com.flybits.commons.library.models.User;
import com.flybits.internal.db.CommonsDatabase;

import java.util.ArrayList;
import java.util.List;

/**
 * The {@code UserCacheLoader} is responsible for loading cached data associated to a
 * {@link com.flybits.commons.library.models.User}. This data is inserted into the local SQLite DB
 * whenever {@link com.flybits.commons.library.models.User} data is received from the Flybits server.
 */
public class UserCacheLoader extends FlybitsCacheLoader<User> {

    private Context context;

    public UserCacheLoader(Context context){
        this.context    = context;
    }

    @Override
    public List<User> load() {
        List<User> listOfUsers = new ArrayList<>();
        listOfUsers.add(CommonsDatabase.getDatabase(context).userDao().getSingle());
        return listOfUsers;
    }

    public User loadLoggedIn(){
        return CommonsDatabase.getDatabase(context).userDao().getSingle();
    }
}
