package com.flybits.commons.library.api.results.callbacks;

import com.flybits.commons.library.exceptions.FlybitsException;

/**
 * Callback used to indicate whether or not a network query was successful or not.
 *
 * @param <T> The item that is expected to be returned.
 */
public interface ObjectResultCallback<T> {
    /**
     * Indicates that the request was successfully made.
     *
     * @param item The item that is expected to be returned.
     */
    void onSuccess(T item);

    /**
     * Indicates that the request failed.
     *
     * @param exception The {@link FlybitsException} that indicates the exception that was
     *                  thrown.
     */
    void onException(FlybitsException exception);
}
