package com.flybits.commons.library.api.results.callbacks;

import com.flybits.commons.library.exceptions.FlybitsException;

/**
 * Callback used to indicate whether or not a network query was successful or not.
 */
public interface BasicResultCallback {
    /**
     * Indicates that the request was successfully made.
     */
    void onSuccess();

    /**
     * Indicates that the request failed.
     *
     * @param exception The {@link FlybitsException} that indicates the exception that was
     *                  thrown.
     */
    void onException(FlybitsException exception);
}
