/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models.internal;

import android.support.annotation.NonNull;
import com.flybits.commons.library.models.internal.OrderBy;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.SortByEnumeratable;
import java.util.ArrayList;

public class QueryBuilder<T extends QueryBuilder> {
    public long limit;
    public long offset;
    public ArrayList<String> labels;
    public OrderBy orderBy;
    public SortByEnumeratable sortBy;

    public QueryBuilder() {
        this.limit = 0L;
        this.offset = -1L;
        this.labels = new ArrayList();
    }

    public QueryBuilder(QueryParameters parameters) {
        this.limit = parameters.getLimit();
        this.offset = parameters.getOffset();
        this.labels = parameters.getLabels();
    }

    public T setLabels(String ... labels) {
        if (labels != null) {
            this.labels.clear();
            for (String label : labels) {
                if (label == null) continue;
                this.labels.add(label);
            }
        }
        return (T)this;
    }

    public T setLabels(@NonNull ArrayList<String> labels) {
        if (labels != null) {
            this.labels.clear();
            this.labels.addAll(labels);
        }
        return (T)this;
    }

    public T setPaging(long limit, long offset) {
        this.limit = limit;
        this.offset = offset;
        return (T)this;
    }

    public T setSorting(@NonNull SortByEnumeratable sort, @NonNull OrderBy order) {
        this.sortBy = sort;
        this.orderBy = order;
        return (T)this;
    }
}

