package com.flybits.commons.library.api.results.callbacks;

import com.flybits.commons.library.exceptions.FlybitsException;

/**
 * Callback used to indicate whether or not the connection request was successful, an error occurred
 * or the user is already logged in so no action should take place.
 */
public interface ConnectionResultCallback {

    /**
     * Indicates that the user is already connected to Flybits.
     */
    void onConnected();

    /**
     * Indicates that the user is not connected.
     */
    void notConnected();

    /**
     * Indicates that the request failed.
     *
     * @param exception The {@link FlybitsException} that indicates the exception that was
     *                  thrown.
     */
    void onException(FlybitsException exception);
}
