/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics;

import android.support.annotation.NonNull;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.Map;

public class SquishyFormatReader {
    private ByteBuffer mInputBuffer;
    private int version;
    private int flags;

    public SquishyFormatReader(@NonNull String b64Data) throws IOException {
        this(Base64.decode((byte[])b64Data.getBytes(), (int)0));
    }

    public SquishyFormatReader(@NonNull byte[] data) throws IOException {
        this.mInputBuffer = ByteBuffer.wrap(data);
        this.mInputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (this.mInputBuffer.getInt() != 1298950470) {
            throw new IOException("Not Squishy format");
        }
        this.version = this.mInputBuffer.getShort();
        this.flags = this.mInputBuffer.getShort();
        this.mInputBuffer.position(this.mInputBuffer.position() + 8);
    }

    public Object getNext() throws BufferUnderflowException {
        byte val = this.mInputBuffer.get();
        int idCode = val & 0xF;
        int numBytes = val >> 4 & 0xF;
        switch (idCode) {
            case 0: {
                byte[] data = new byte[8];
                this.mInputBuffer.get(data, 0, numBytes);
                return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getLong();
            }
            case 1: {
                byte[] data = new byte[8];
                this.mInputBuffer.get(data, 0, numBytes);
                return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            }
            case 2: {
                return this.readNullTermedString();
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                return null;
            }
            case 6: {
                return this.readMap();
            }
            case 7: {
                return this.readArray();
            }
        }
        return null;
    }

    private Object[] readArray() {
        int numEntries = this.mInputBuffer.getInt();
        Object[] array = new Object[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            array[i] = this.getNext();
        }
        return array;
    }

    private Map<Object, Object> readMap() {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int numEntries = this.mInputBuffer.getInt();
        for (int i = 0; i < numEntries; ++i) {
            Object key = this.getNext();
            Object value = this.getNext();
            map.put(key, value);
        }
        return map;
    }

    private String readNullTermedString() {
        byte b;
        ByteArrayOutputStream stringBytes = new ByteArrayOutputStream();
        while ((b = this.mInputBuffer.get()) != 0) {
            stringBytes.write(b);
        }
        return new String(stringBytes.toByteArray());
    }

    public int getVersion() {
        return this.version;
    }

    public int flags() {
        return this.flags;
    }
}

