/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.caching;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public abstract class FlybitsUIListObserver<T> {
    private DataChanged<T> callback;
    private LiveData<List<T>> item;
    private Observer<List<T>> observer;
    private List<T> itemsLoaded = new ArrayList<T>();

    public void add(DataChanged<T> callback) {
        this.callback = callback;
    }

    @Nullable
    public LiveData<List<T>> getData() {
        return this.item;
    }

    public void remove() {
        if (this.item != null && this.item.hasActiveObservers()) {
            this.item.removeObserver(this.observer);
        }
    }

    public List<T> getItems() {
        return this.itemsLoaded;
    }

    public void setItems(LiveData<List<T>> item) {
        this.item = item;
        this.observer = new Observer<List<T>>(){

            public void onChanged(@Nullable List<T> items) {
                if (FlybitsUIListObserver.this.itemsLoaded.size() == 0) {
                    FlybitsUIListObserver.this.itemsLoaded.addAll(items);
                    if (FlybitsUIListObserver.this.callback != null) {
                        FlybitsUIListObserver.this.callback.onCacheLoaded(items);
                    }
                } else if (FlybitsUIListObserver.this.callback != null) {
                    FlybitsUIListObserver.this.callback.onUpdate(items);
                }
            }
        };
        this.item.observeForever(this.observer);
    }

    public static interface DataChanged<T> {
        public void onUpdate(List<T> var1);

        public void onCacheLoaded(List<T> var1);
    }
}

