/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.QueryStatus;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import java.util.concurrent.ExecutorService;

public class ObjectResult<T>
extends FlybitsResult {
    private T object;
    private ObjectResultCallback<T> callback;

    public ObjectResult(@NonNull Context context, ObjectResultCallback<T> callback) {
        super(context);
        this.callback = callback;
    }

    public ObjectResult(@NonNull Context context, ObjectResultCallback<T> callback, @NonNull ExecutorService service) {
        super(context, service);
        this.callback = callback;
    }

    public T getResult() {
        if (this.getStatus() == QueryStatus.SUCCESS) {
            return this.object;
        }
        return null;
    }

    @Override
    public boolean setFailed(FlybitsException e) {
        if (super.setFailed(e)) {
            if (this.callback != null) {
                this.callback.onException(e);
            }
            return true;
        }
        return false;
    }

    protected void setSuccess(@NonNull T result) {
        if (this.setSuccess()) {
            this.object = result;
            if (this.callback != null) {
                this.callback.onSuccess(result);
            }
        }
    }

    public void setResult(@NonNull Result<T> result) {
        if (result.getStatus() == RequestStatus.COMPLETED) {
            this.setSuccess(result.getResult());
        } else {
            this.setFailed(result.getException());
        }
    }
}

