/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.NetworkResponseException;
import com.flybits.commons.library.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class DeserializeNetworkError
extends IDeserializer<NetworkResponseException> {
    @Override
    public String toJson(NetworkResponseException obj) {
        JSONObject object = new JSONObject();
        return object.toString();
    }

    @Override
    public NetworkResponseException fromJson(String json) {
        try {
            Object jsonObject = new JSONTokener(json).nextValue();
            if (jsonObject instanceof JSONObject) {
                JSONObject jObject = new JSONObject(json);
                return this.fromJson(jObject);
            }
            if (jsonObject instanceof JSONArray) {
                JSONArray jObject = new JSONArray(json);
                return this.fromJson(jObject);
            }
            return new NetworkResponseException(json);
        }
        catch (NullPointerException | JSONException throwable) {
            return null;
        }
    }

    @Override
    public NetworkResponseException fromJson(JSONObject jObj) {
        try {
            JSONObject jObj2;
            if (!(jObj.isNull("error") || (jObj2 = jObj.getJSONObject("error")).isNull("exceptionType") || jObj2.isNull("exceptionMessage"))) {
                String type = jObj2.getString("exceptionType");
                String message = jObj2.getString("exceptionMessage");
                if (!jObj2.isNull("requestId")) {
                    String requestId = jObj2.getString("requestId");
                    return new NetworkResponseException(message, requestId, type);
                }
                return new NetworkResponseException(message, type);
            }
        }
        catch (JSONException e) {
            Logger.exception("DeserializeNetworkError.fromJson", (Exception)((Object)e));
        }
        return null;
    }

    @Override
    public NetworkResponseException fromJson(JSONArray jsonObject) {
        return null;
    }
}

