/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.analytics.AnalyticsOptions;
import com.flybits.commons.library.analytics.Properties;
import com.flybits.commons.library.api.Analytics;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.FlyJWT;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.idps.FlybitsIDP;
import com.flybits.commons.library.api.idps.IDP;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ConnectionResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ConnectionResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializeLogin;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.DeserializeProject;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidFlybitsManagerException;
import com.flybits.commons.library.http.HttpDefaultClass;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.Jwt;
import com.flybits.commons.library.models.Project;
import com.flybits.commons.library.models.ProjectParameters;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.results.ProjectsResult;
import com.flybits.internal.db.CommonsDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FlybitsManager {
    static final String AUTHENTICATION_API = "/sso/auth";
    static final String PROJECTS_API = "/kernel/projects";
    static final String PROJECT_ENDPOINT = "/sso/auth/project";
    static final String DISCONNECT_ENDPOINT = "/sso/auth/logout";
    static final String ME_ENDPOINT = "/sso/auth/me";
    public static boolean IS_DEBUG = false;
    private AnalyticsOptions analyticsOptions;
    private Context context;
    private boolean enableAnalytics;
    private IDP idProvider;
    private boolean isDebug;
    private ArrayList<String> languageCodes;
    private Set<FlybitsScope> listOfScopes;

    private FlybitsManager(Builder builder) {
        this.listOfScopes = builder.listOfScopes;
        this.context = builder.mContext;
        this.isDebug = builder.isDebug;
        this.enableAnalytics = builder.enableAnalytics;
        this.languageCodes = builder.languageCodes;
        this.idProvider = builder.idProvider;
        if (this.languageCodes.size() == 0) {
            this.languageCodes.add("en");
        }
        IS_DEBUG = this.isDebug;
        if (this.enableAnalytics) {
            this.analyticsOptions = builder.analyticsOptions != null ? builder.analyticsOptions : new AnalyticsOptions.Builder(this.context).setStorageType(AnalyticsOptions.StorageType.SQLITE_DB).setUploadServiceTime(60L, 60L, TimeUnit.HOURS).build();
        }
    }

    public static void setDebug() {
        IS_DEBUG = true;
    }

    public ConnectionResult connect(ConnectionResultCallback callback) {
        return this.connect(callback, true);
    }

    public ConnectionResult connect(IDP idp, ConnectionResultCallback callback, boolean autoUseManifestProject) {
        this.idProvider = idp;
        return this.connect(callback, autoUseManifestProject);
    }

    public ConnectionResult connect(IDP idp, ConnectionResultCallback callback) {
        this.idProvider = idp;
        return this.connect(callback, true);
    }

    public ConnectionResult connect(ConnectionResultCallback callback, final boolean autoUseManifestProject) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ConnectionResult query = new ConnectionResult(this.context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result jwtResult = FlyJWT.refreshJWT(FlybitsManager.this.context);
                    if (jwtResult.getStatus() == RequestStatus.COMPLETED) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                query.setResult(jwtResult);
                            }
                        });
                    } else if (FlybitsManager.this.idProvider != null) {
                        String body = FlybitsManager.this.idProvider.getRequestBody(FlybitsManager.this.context, autoUseManifestProject).toString();
                        String url = FlybitsManager.AUTHENTICATION_API + FlybitsManager.this.idProvider.getAuthenticationEndPoint();
                        final Result<User> authenticatedUser = FlyAway.post(FlybitsManager.this.context, url, body, new DeserializeLogin(), "FlybitsManager.connect", User.class);
                        if (authenticatedUser.getStatus() == RequestStatus.COMPLETED) {
                            CommonsDatabase.getDatabase(FlybitsManager.this.context).userDao().insert(authenticatedUser.getResult());
                            SharedElements.setConnectedIDP(FlybitsManager.this.context, FlybitsManager.this.idProvider.getProvider());
                            if (!Analytics.isInitialized() && FlybitsManager.this.enableAnalytics) {
                                Analytics.initialize(FlybitsManager.this.analyticsOptions);
                                Properties properties = new Properties();
                                properties.addProperty("idpType", FlybitsManager.this.idProvider.getClass().getCanonicalName());
                                Analytics.logEventFlybits("SDK - Connected", properties);
                            }
                            for (FlybitsScope scope : FlybitsManager.this.listOfScopes) {
                                scope.onConnected(authenticatedUser.getResult());
                            }
                        }
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                query.setResult(authenticatedUser);
                            }
                        });
                        SharedElements.setLocalization(FlybitsManager.this.context, FlybitsManager.this.languageCodes);
                    } else {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                query.setNotConnected();
                            }
                        });
                    }
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            query.setFailed(e);
                        }
                    });
                }
            }
        });
        return query;
    }

    public ProjectsResult getProjects(final ProjectParameters params, PagedResultCallback<Project> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ProjectsResult result = new ProjectsResult(this.context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean isConnnected;
                    boolean bl = isConnnected = !SharedElements.getSavedJWTToken(FlybitsManager.this.context).equals("");
                    if (!isConnnected || !(FlybitsManager.this.getIDP() instanceof FlybitsIDP)) {
                        throw new FlybitsException("Either not yet connected to Flybits, or you are not using the Flybits IDP. GetProjects() only works with the Flybits IDP.");
                    }
                    DeserializeProject singleDeserializaer = new DeserializeProject();
                    DeserializePagedResponse deserializer = new DeserializePagedResponse(singleDeserializaer);
                    final Result projectList = FlyAway.get(FlybitsManager.this.context, FlybitsManager.PROJECTS_API, params, deserializer, "FlybitsManager.getProjects");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            result.setResult(projectList, params);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            result.setFailed(e);
                        }
                    });
                }
            }
        });
        return result;
    }

    public BasicResult bindProject(final String projectId, BasicResultCallback callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(this.context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String currentJwtToken = SharedElements.getSavedJWTToken(FlybitsManager.this.context);
                    Jwt currentJwt = Jwt.decodeJWTToken(currentJwtToken);
                    if (currentJwt.isProjectBound()) {
                        throw new FlybitsException("There is already a project bound, the client must logout first.");
                    }
                    HashMap<String, String> headers = new HashMap<String, String>();
                    String url = FlybitsAPIConstants.constructGatewayURL(FlybitsManager.this.context, String.format("%s?projectId=%s", FlybitsManager.PROJECT_ENDPOINT, projectId));
                    try {
                        final Result bound = new HttpDefaultClass.Builder(FlybitsManager.this.context, true, url).addHeaders(headers).get().getResponse();
                        if (bound != null && bound.getStatus() == RequestStatus.COMPLETED && !Analytics.isInitialized() && FlybitsManager.this.enableAnalytics) {
                            Analytics.initialize(FlybitsManager.this.analyticsOptions);
                        }
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                request.setResult(bound);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new FlybitsException("Error Connecting to Flybits Server: FlybitsManager.bindProject");
                    }
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public BasicResult destroy(BasicResultCallback callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(this.context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Analytics.isInitialized()) {
                        Analytics.destroy(FlybitsManager.this.context);
                    }
                    String jwtToken = SharedElements.getSavedJWTToken(FlybitsManager.this.context);
                    final Result deleteUser = FlyAway.delete(FlybitsManager.this.context, FlybitsManager.ME_ENDPOINT, "FlybitsManager.destroy", null);
                    if (deleteUser.getStatus() == RequestStatus.COMPLETED) {
                        FlybitsManager.clearUserInformation(FlybitsManager.this.context);
                        CommonsDatabase.getDatabase(FlybitsManager.this.context).userDao().delete();
                        for (FlybitsScope scope : FlybitsManager.this.listOfScopes) {
                            scope.onAccountDestroyed(jwtToken);
                        }
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(deleteUser);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public BasicResult disconnect(BasicResultCallback callback) {
        return this.disconnect(callback, false);
    }

    public BasicResult disconnect(BasicResultCallback callback, final boolean disconnectOnException) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(this.context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Analytics.isInitialized()) {
                        Analytics.destroy(FlybitsManager.this.context);
                    }
                    String jwtToken = SharedElements.getSavedJWTToken(FlybitsManager.this.context);
                    final Result disconnected = FlyAway.post(FlybitsManager.this.context, FlybitsManager.DISCONNECT_ENDPOINT, "", null, "FlybitsManager.disconnect", null);
                    if (disconnected.getStatus() == RequestStatus.COMPLETED || disconnectOnException) {
                        FlybitsManager.clearUserInformation(FlybitsManager.this.context);
                        CommonsDatabase.getDatabase(FlybitsManager.this.context).userDao().delete();
                    }
                    if (disconnected.getStatus() == RequestStatus.COMPLETED) {
                        if (Analytics.isInitialized()) {
                            Analytics.logEventFlybits("SDK - Disconnected", null);
                        }
                        for (FlybitsScope scope : FlybitsManager.this.listOfScopes) {
                            scope.onDisconnected(jwtToken);
                        }
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(disconnected);
                        }
                    });
                }
                catch (FlybitsException e) {
                    if (disconnectOnException) {
                        FlybitsManager.clearUserInformation(FlybitsManager.this.context);
                        CommonsDatabase.getDatabase(FlybitsManager.this.context).userDao().delete();
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public static ObjectResult<User> getUser(final Context context, ObjectResultCallback<User> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult<User> request = new ObjectResult<User>(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result<User> getUser = FlyAway.get(context, FlybitsManager.ME_ENDPOINT, new DeserializeLogin(), "FlybitsManager.get", User.class);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(getUser);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public static ObjectResult<User> getUser(final Context context) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult<User> request = new ObjectResult<User>(context, null, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result<User> getUser = FlyAway.get(context, FlybitsManager.ME_ENDPOINT, new DeserializeLogin(), "FlybitsManager.get", User.class);
                    if (getUser.getStatus() == RequestStatus.COMPLETED) {
                        CommonsDatabase.getDatabase(context).userDao().update(getUser.getResult());
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(getUser);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public static ConnectionResult isConnected(final @NonNull Context context, final boolean confirmThroughNetwork, final @NonNull ConnectionResultCallback callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ConnectionResult query = new ConnectionResult(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (confirmThroughNetwork && !SharedElements.getSavedJWTToken(context).equals("")) {
                    try {
                        final Result getJWT = FlyJWT.refreshJWT(context);
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (getJWT.getStatus() == RequestStatus.NOT_CONNECTED) {
                                    callback.notConnected();
                                } else if (getJWT.getStatus() == RequestStatus.COMPLETED) {
                                    callback.onConnected();
                                } else {
                                    callback.onException(getJWT.getException());
                                }
                            }
                        });
                    }
                    catch (FlybitsException e) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onException(e);
                            }
                        });
                    }
                } else if (SharedElements.getSavedJWTToken(context).equals("")) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.notConnected();
                        }
                    });
                } else {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onConnected();
                        }
                    });
                }
            }
        });
        return query;
    }

    static void clearUserInformation(Context context) {
        SharedPreferences preferences = SharedElements.getPreferences(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.clear();
        editor.apply();
    }

    IDP getIDP() {
        return this.idProvider;
    }

    Set<FlybitsScope> getScopes() {
        return this.listOfScopes;
    }

    boolean isDebug() {
        return this.isDebug;
    }

    boolean isAnalyticsEnabled() {
        return this.enableAnalytics;
    }

    public static final class Builder {
        private final Set<FlybitsScope> listOfScopes;
        private Context mContext;
        private IDP idProvider;
        private boolean isDebug;
        private boolean enableAnalytics;
        private AnalyticsOptions analyticsOptions;
        private ArrayList<String> languageCodes;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.listOfScopes = new HashSet<FlybitsScope>();
            this.languageCodes = new ArrayList();
            try {
                this.languageCodes.add(Locale.getDefault().getLanguage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Builder addScope(@NonNull FlybitsScope scope) {
            this.listOfScopes.add(scope);
            return this;
        }

        public FlybitsManager build() throws InvalidFlybitsManagerException {
            this.checkIfFieldsSet();
            return new FlybitsManager(this);
        }

        public Builder enableAnalytics() {
            this.enableAnalytics = true;
            return this;
        }

        public Builder overrideAnalyticsOptions(AnalyticsOptions options) {
            this.analyticsOptions = options;
            return this.enableAnalytics();
        }

        public Builder setAccount(IDP idp) {
            this.idProvider = idp;
            return this;
        }

        public Builder setDebug() {
            this.isDebug = true;
            return this;
        }

        public Builder setLanguage(@NonNull String languageCode) {
            this.languageCodes.clear();
            this.languageCodes.add(languageCode);
            return this;
        }

        private void checkIfFieldsSet() throws InvalidFlybitsManagerException {
            Properties properties = new Properties();
            if (this.listOfScopes.size() == 0) {
                if (Analytics.isInitialized()) {
                    Analytics.logEventFlybits("Missing Scope", properties);
                }
                throw new InvalidFlybitsManagerException("You must have at least 1 scope set to create a valid FlybitsManager object");
            }
            if (this.languageCodes.size() != 1 && this.languageCodes.get(0).length() != 2) {
                if (Analytics.isInitialized()) {
                    Analytics.logEventFlybits("Invalid Language Code", properties);
                }
                throw new InvalidFlybitsManagerException("Your language must be a 2-letter code. Make sure you call setLanguage(String)");
            }
        }
    }
}

