package com.flybits.commons.library.models;

/*
Defines a single Flybits Project retrieved by getProjects() in the {@code FlybitsManager} class.
 */
public class Project {

    private String creatorId;
    private String id;
    private boolean isActive;
    private String name;
    private String subdomain;
    private String tierId;

    /**
    Instantiates a {@code Project}.
     @param id The id of this project.
     @param creatorId The id of the user that created this project.
     @param name The name of this project
     @param subdomain The subdomain to access this project's Experience Studio (IE: subdomain.flybits.com)
     @param tierId The subscription tier this project is active on.
     @param isActive True if the project is activated.
     */
    public Project(String id, String creatorId, String name, String subdomain, String tierId, boolean isActive)
    {
        this.creatorId = creatorId;
        this.id = id;
        this.isActive = isActive;
        this.name = name;
        this.subdomain = subdomain;
        this.tierId = tierId;
    }

    /**
     * Returns this project's id.
     * @return The id of this project.
     */
    public String getId()
    {
        return id;
    }

    /**
     * Returns this project's owner's id.
     * @return The id of the owner that created this project.
     */
    public String getCreatorId()
    {
        return creatorId;
    }

    /**
     * Returns this project's name.
     * @return The name of this project.
     */
    public String getName()
    {
        return name;
    }

    /**
     * Returns this project's subdomain.
     * @return The subdomain.
     */
    public String getSubdomain()
    {
        return subdomain;
    }

    /**
     * Returns the tier level of this project.
     * @return The tier level of this project.
     */
    public String getTierId()
    {
        return tierId;
    }

    /**
     * Returns if project is active.
     * @return True if project is active.
     */
    public boolean isActive()
    {
        return isActive;
    }

}
