package com.flybits.commons.library.api.results.callbacks;

import java.util.ArrayList;

/**
 * Callback used to indicate whether or not the network request for a list response was successful
 * or not.
 *
 * @param <T> The item that is expected to be returned as a list for this query.
 */
public interface PagedResultWithCacheCallback<T> extends PagedResultCallback<T>{

    /**
     * This method is called when retrieving data form the caching layer of the DB. This returns
     * the list of cached {@code T} data.
     *
     * @param items The item that is expected to be returned as a list for this query.
     */
    void onCacheLoaded(ArrayList<T> items);
}
