package com.flybits.commons.library.api.idps;


import org.json.JSONException;
import org.json.JSONObject;

/**
 * The {@code SignedIDP} class is responsible for creating the specification for an IDentity Provider
 * (IDP) that can be logged into using the SAML protocol. The {@code SignedIDP} creates a
 * {@link com.flybits.commons.library.models.User} based on the information retrieved from the
 * SAML IDP regardless of where the IDP is hosted.
 */
public class SignedIDP extends IDP{

    private static final String AUTHENTICATE_ENDPOINT       = "/signedLogin";

    private String accessToken;
    private String signature;

    /**
     * Constructor used to register to an identity provider using a signed access token that
     * requires a confirm signiture used to sign the {@code accessToken}.
     *
     * @param accessToken The access token obtained from the 3rd party source.
     * @param signature The access token signature used to validate the access token.
     */
    public SignedIDP(String accessToken, String signature){
        super("signedLogin");
        this.accessToken    = accessToken;
        this.signature      = signature;
    }

    @Override
    public String getAuthenticationEndPoint() {
        return AUTHENTICATE_ENDPOINT;
    }

    @Override
    public JSONObject getBody() {
        JSONObject bodyObject   = new JSONObject();

        try {
            bodyObject.put("accessToken", accessToken);
        }catch (JSONException e){}
        try {
            bodyObject.put("signature", signature);
        }catch (JSONException e){}

        return bodyObject;
    }
}
