package com.flybits.commons.library.caching;

import android.content.Context;

import com.flybits.commons.library.models.User;
import com.flybits.internal.db.CommonsDatabase;

/**
 * The {@code FlybitsUserObserver} class is responsible for creating an {@code Observer} for logged
 * in {@link User} object. This {@code Observer} listens to profile changes and notifies the UI
 * appropriate if whenever a change is detected. It will also trigger the retrieval of the initial
 * {@link User} object from the DB in order to initialize the view.
 */
public class FlybitsUserObserver extends FlybitsUIObjectObserver<User> {

    private static FlybitsUserObserver INSTANCE = null;
    private FlybitsUserObserver(final Context context){
        new Thread(new Runnable() {
            @Override
            public void run() {
                setItem(CommonsDatabase.getDatabase(context).userDao().get());
            }
        }).start();
    }

    /**
     * As the {@code FlybitsUserObserver} class acts as a {@code Singleton}, it is important to
     * initialize the {@code Singleton} with the proper attributes needed to function correctly.
     *
     * @param context The context of the application.
     * @return The instance of the {@code FlybitsUserObserver} class which has either been
     * previously initialized or was initialized for the first time now.
     */
    public static FlybitsUserObserver observe(Context context) {
        if (INSTANCE == null) {
            synchronized (FlybitsUserObserver.class){
                if (INSTANCE == null){
                    INSTANCE = new FlybitsUserObserver(context);
                }
            }
        }
        return INSTANCE;
    }

    @Override
    public void remove() {
        super.remove();
        if (getData() != null && !getData().hasActiveObservers()){
            INSTANCE = null;
        }
    }
}
