/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.idps;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.exceptions.MissingProjectIDException;
import com.flybits.commons.library.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class IDP {
    private String provider;

    public IDP(String provider) {
        this.provider = provider;
    }

    public abstract String getAuthenticationEndPoint();

    public String getProjectID(Context mContext) throws MissingProjectIDException {
        try {
            ApplicationInfo ai = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            if (bundle.containsKey("com.flybits.projectID")) {
                String projectID = bundle.getString("com.flybits.projectID");
                SharedElements.setProjectID(mContext, projectID);
                return projectID;
            }
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Logger.exception("IDP.getProjectID", (Exception)e);
        }
        throw new MissingProjectIDException("Your Flybits ProjectID has not been set. Please make sure you set it within the AndroidManifest.xml file under the meta key: 'com.flybits.projectID'");
    }

    public String getProvider() {
        return this.provider;
    }

    public JSONObject getRequestBody(Context mContext) throws MissingProjectIDException {
        JSONObject bodyObject = this.getBody();
        if (bodyObject == null) {
            bodyObject = new JSONObject();
        }
        try {
            bodyObject.put("projectId", (Object)this.getProjectID(mContext));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return bodyObject;
    }

    public abstract JSONObject getBody();
}

