/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.idps;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.api.idps.IDP;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.HttpDefaultClass;
import com.flybits.commons.library.models.internal.Result;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class FlybitsIDP
extends IDP {
    private static final String AUTHENTICATE_ENDPOINT = "/authenticate";
    private static final String RESET_PASSWORD_ENDPOINT = "/sso/auth/sendResetPasswordEmail";
    private String firstName;
    private String lastName;
    private String email;
    private String password;

    public FlybitsIDP(@NonNull String email, @NonNull String password, String firstName, String lastName) {
        this(email, password);
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public FlybitsIDP(@NonNull String email, @NonNull String password) {
        this();
        this.email = email;
        this.password = password;
    }

    private FlybitsIDP() {
        super("flybits");
    }

    @Override
    public String getAuthenticationEndPoint() {
        return AUTHENTICATE_ENDPOINT;
    }

    @Override
    public JSONObject getBody() {
        JSONObject bodyObject = new JSONObject();
        try {
            bodyObject.put("email", (Object)this.email);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            bodyObject.put("password", (Object)this.password);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (this.firstName != null && this.lastName != null) {
            try {
                bodyObject.put("firstName", (Object)this.firstName);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                bodyObject.put("lastName", (Object)this.lastName);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return bodyObject;
    }

    public static BasicResult requestNewPassword(final @NonNull Context context, final @NonNull String email, @NonNull BasicResultCallback callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                String body = "{\"email\" : \"" + email + "\"}";
                String url = FlybitsAPIConstants.getGatewayURL(context) + FlybitsIDP.RESET_PASSWORD_ENDPOINT;
                try {
                    final Result result = new HttpDefaultClass.Builder(context, false, url).post(body).getResponse();
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(result);
                        }
                    });
                }
                catch (Exception e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (e instanceof FlybitsException) {
                                request.setFailed((FlybitsException)e);
                            } else {
                                request.setFailed(new FlybitsException(e));
                            }
                        }
                    });
                }
            }
        });
        return request;
    }
}

