package com.flybits.commons.library.models.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * The {@link QueryParameters} class is used to define all common parameters that can be added to
 * any GET request in order to filter the results requested. For example, you may want to add paging
 * to your GET request in order to get a different set of results.
 */
public class QueryParameters {

    private long limit;
    private long offset;
    private ArrayList<String> labels;

    /**
     * Default constructor that initializes all the local variables including {@code limit} and
     * {@code offset} used for paging, and an empty {@code labels} list for filtering by label.
     */
    public QueryParameters(QueryBuilder builder) {
        limit   = builder.limit;
        offset  = builder.offset;
        labels  = builder.labels;
    }

    /**
     * Get the list of query parameters that should be added to the GET request.
     *
     * @return A list of parameters that should be added to the GET query.
     */
    public Map<String, ArrayList<String>> getQueryParams(){

        Map<String, ArrayList<String>> params = new HashMap<>();

        if (limit > 0 && offset > -1) {

            ArrayList<String> limitParam = new ArrayList<>();
            limitParam.add( String.valueOf(limit));
            params.put("limit", limitParam);

            ArrayList<String> offsetParam = new ArrayList<>();
            offsetParam.add(String.valueOf(offset));
            params.put("offset", offsetParam);
        }

        if (labels.size() > 0) {
            ArrayList<String> labelsParam = new ArrayList<>();
            labelsParam.addAll(labels);
            params.put("labels", labelsParam);
        }

        return params;
    }

    public long getLimit() {
        return limit;
    }

    public long getOffset() {
        return offset;
    }

    public ArrayList<String> getLabels() {
        return labels;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLabels(ArrayList<String> labels) {
        this.labels = labels;
    }
}
