/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.callbacks.ConnectionResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import java.util.concurrent.ExecutorService;

public class ConnectionResult
extends FlybitsResult {
    private ConnectionResultCallback callback;

    public ConnectionResult(Context context, ConnectionResultCallback callback) {
        super(context);
        this.callback = callback;
    }

    public ConnectionResult(Context context, ConnectionResultCallback callback, ExecutorService service) {
        super(context, service);
        this.callback = callback;
    }

    @Override
    public boolean setFailed(FlybitsException e) {
        if (super.setFailed(e)) {
            this.callback.onException(e);
            return true;
        }
        return false;
    }

    public void setConnected() {
        if (this.setSuccess()) {
            this.callback.onConnected();
        }
    }

    public void setNotConnected() {
        if (this.setSuccess()) {
            this.callback.notConnected();
        }
    }

    public void setResult(Result<User> result) {
        if (result.getStatus() == RequestStatus.COMPLETED) {
            this.setConnected();
        } else {
            this.setFailed(result.getException());
        }
    }
}

