/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyJWT;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.internal.DeserializeMQTTNotification;
import com.flybits.internal.PushInternal;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.paho.android.service.MqttAndroidClient;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class FlybitsMQTTService
extends Service {
    static final String INTERNAL_FLYBITS_PUSH_SCOPE_KERNEL = "com.flybits.action.push.scope.kernel";
    static final String INTERNAL_FLYBITS_PUSH_SCOPE_PUSH = "com.flybits.action.push.scope.push";
    static final String INTERNAL_FLYBITS_PUSH_SCOPE_CONTEXT = "com.flybits.action.push.scope.context";
    static final String INTERNAL_FLYBITS_PUSH_DATA = "com.flybits.action.push.param.data";
    static final String INTERNAL_FLYBITS_PUSH_ACTION = "com.flybits.action.push.param.action";
    static final String INTERNAL_FLYBITS_PUSH_ENTITY = "com.flybits.action.push.param.entity";
    private final int MINTIMEOUT = 1;
    private final int MAXTIMEOUT = 256;
    private int timeout = 1;
    public static final String MQTT_SUBSCRIBE = "mqtt-subscribe";
    public static final String MQTT_DISCONNECT = "mqtt-disconnect";
    public static final String MQTT_CONNECT = "mqtt-connect";
    public static final String MQTT_PUBLISH = "mqtt-publish";
    public static final String IS_SUBSCRIBE = "mqtt-event:IS_SUBSCRIBE";
    public static final String TOPICS = "topics";
    private Handler handler;
    private Vector<String> topics;
    private Random rand;
    private static final int QOS_WILL = 1;
    private static final int QOS = 0;
    private static final int KEEP_ALIVE = 30;
    private static final String _TAG = "FlybitsMQTTService";
    private MqttAndroidClient client;
    private MqttCallbackExtended callback = new MqttCallbackExtended(){

        public void connectComplete(boolean b, String s) {
        }

        public void connectionLost(Throwable cause) {
            Logger.setTag(FlybitsMQTTService._TAG).d("connectionLost: " + cause);
            if (cause != null) {
                FlybitsMQTTService.this.errorConnecting();
            }
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            new Thread(() -> {
                Logger.setTag(FlybitsMQTTService._TAG).i(topic + ":" + message.toString());
                String pushNotification = message.toString();
                FlybitsMQTTService.this.parseNotification(pushNotification);
            }).start();
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    };
    private BroadcastReceiver mSubscription = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ArrayList listOfTopics = intent.getStringArrayListExtra(FlybitsMQTTService.TOPICS);
            boolean isSubsribe = intent.getBooleanExtra(FlybitsMQTTService.IS_SUBSCRIBE, false);
            Logger.setTag(FlybitsMQTTService._TAG).d("Topic: " + listOfTopics);
            new Thread(() -> {
                if (isSubsribe) {
                    FlybitsMQTTService.this.subscribe(listOfTopics);
                } else {
                    FlybitsMQTTService.this.unsubscribe(listOfTopics);
                }
            }).start();
        }
    };
    private BroadcastReceiver mDisconnection = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Logger.setTag(FlybitsMQTTService._TAG).d("BroadcastReceiver mDisconnection");
            try {
                FlybitsMQTTService.this.disconnect();
            }
            catch (MqttException e) {
                Logger.exception("FlybitsMQTTService.mDisconnection", (Exception)((Object)e));
            }
        }
    };
    private BroadcastReceiver mConnect = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Logger.setTag(FlybitsMQTTService._TAG).d("BroadcastReceiver mConnection");
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.execute(() -> FlybitsMQTTService.this.connect());
        }
    };
    private BroadcastReceiver mPublish = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
        }
    };
    private Runnable runnableConnection = () -> new Thread(() -> {
        Logger.setTag(_TAG).d("runnableConnection");
        this.connect();
    }).start();

    public void onCreate() {
        super.onCreate();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mSubscription, new IntentFilter(MQTT_SUBSCRIBE));
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mDisconnection, new IntentFilter(MQTT_DISCONNECT));
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mPublish, new IntentFilter(MQTT_PUBLISH));
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mConnect, new IntentFilter(MQTT_CONNECT));
        this.handler = new Handler();
        this.topics = new Vector();
        this.rand = new Random();
        new Thread(() -> this.connect()).start();
        return 1;
    }

    private void connect() {
        String projectID = SharedElements.getProjectID(this.getBaseContext());
        String deviceID = SharedElements.getDeviceID(this.getBaseContext());
        String userID = SharedElements.getUserID(this.getBaseContext());
        String jwt = SharedElements.getSavedJWTToken(this.getBaseContext());
        if (jwt == null) {
            jwt = "";
        }
        String MQTT_url = FlybitsAPIConstants.getMQTTURL();
        String clientID = deviceID + "_" + projectID;
        this.client = new MqttAndroidClient(this.getBaseContext(), MQTT_url, clientID);
        try {
            IMqttToken token = this.client.connect(this.getMqttConnectionOptions(jwt, userID, deviceID, projectID));
            if (token != null) {
                token.setActionCallback(new IMqttActionListener(){

                    public void onSuccess(IMqttToken asyncActionToken) {
                        Logger.setTag(FlybitsMQTTService._TAG).d("connected");
                        FlybitsMQTTService.this.client.setBufferOpts(FlybitsMQTTService.this.getDisconnectedBufferOptions());
                        new Thread(() -> {
                            if (FlybitsMQTTService.this.client.isConnected()) {
                                FlybitsMQTTService.this.topics.add(SharedElements.getDeviceID(FlybitsMQTTService.this.getBaseContext()) + "_" + SharedElements.getProjectID(FlybitsMQTTService.this.getBaseContext()));
                                if (FlybitsMQTTService.this.topics.size() > 0) {
                                    ArrayList list = new ArrayList(FlybitsMQTTService.this.topics);
                                    FlybitsMQTTService.this.subscribe(list);
                                    FlybitsMQTTService.this.topics.clear();
                                }
                            }
                        }).start();
                    }

                    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                        Logger.setTag(FlybitsMQTTService._TAG).d("Failure " + exception.toString());
                        if (exception instanceof MqttException && ((MqttException)exception).getReasonCode() == 4) {
                            ExecutorService executorService = Executors.newSingleThreadExecutor();
                            executorService.execute(() -> {
                                try {
                                    Result result = FlyJWT.refreshJWT(FlybitsMQTTService.this.getBaseContext());
                                    if (result.getStatus() != RequestStatus.COMPLETED) {
                                        FlybitsMQTTService.this.disconnect();
                                    }
                                }
                                catch (FlybitsException | MqttException e) {
                                    Logger.exception("FlybitsMQTTService.connect.onFailure", (Exception)e);
                                }
                            });
                        }
                        FlybitsMQTTService.this.errorConnecting();
                    }
                });
            }
        }
        catch (MqttException e) {
            Logger.exception("FlybitsMQTTService.onCreate", (Exception)((Object)e));
        }
        this.client.setCallback((MqttCallback)this.callback);
    }

    private void subscribe(ArrayList<String> listOfTopics) {
        for (String topic : listOfTopics) {
            if (topic.isEmpty()) continue;
            if (this.client != null && this.client.isConnected()) {
                try {
                    this.client.subscribe(topic, 0);
                }
                catch (MqttException e) {
                    Logger.exception("FlybitsMQTTService.subscribe", (Exception)((Object)e));
                }
                continue;
            }
            this.topics.add(topic);
        }
    }

    private void unsubscribe(ArrayList<String> listOfTopics) {
        for (String topic : listOfTopics) {
            if (topic.isEmpty()) continue;
            if (this.client != null && this.client.isConnected()) {
                try {
                    this.client.unsubscribe(topic);
                }
                catch (MqttException e) {
                    Logger.exception("FlybitsMQTTService.subscribe", (Exception)((Object)e));
                }
                continue;
            }
            this.topics.remove(topic);
        }
    }

    private void disconnect() throws MqttException {
        if (this.client != null && this.client.isConnected()) {
            IMqttToken mqttToken = this.client.disconnect();
            mqttToken.setActionCallback(new IMqttActionListener(){

                public void onSuccess(IMqttToken iMqttToken) {
                    Logger.setTag(FlybitsMQTTService._TAG).d("Successfully disconnected");
                    FlybitsMQTTService.this.client.unregisterResources();
                    FlybitsMQTTService.this.client.close();
                    FlybitsMQTTService.this.client = null;
                }

                public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
                    Logger.setTag(FlybitsMQTTService._TAG).d("Failed to disconnected " + throwable.toString());
                }
            });
        }
    }

    private MqttConnectOptions getMqttConnectionOptions(String jwt, String userID, String deviceID, String projectID) {
        String clientID = deviceID + "_" + projectID;
        String will = userID + "_" + deviceID + "_" + projectID;
        Logger.setTag(_TAG).d("JWT Username: " + clientID);
        Logger.setTag(_TAG).d("JWT Password: " + jwt);
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setAutomaticReconnect(true);
        mqttConnectOptions.setCleanSession(false);
        mqttConnectOptions.setUserName(clientID);
        mqttConnectOptions.setPassword(jwt.toCharArray());
        mqttConnectOptions.setKeepAliveInterval(30);
        try {
            mqttConnectOptions.setWill("flybits.mqtt.offline", will.getBytes("UTF-8"), 1, false);
        }
        catch (UnsupportedEncodingException | IllegalStateException e) {
            Logger.exception("FlybitsMQTTService.connect.UnsupportedEncodingException", e);
            return null;
        }
        return mqttConnectOptions;
    }

    @NonNull
    private DisconnectedBufferOptions getDisconnectedBufferOptions() {
        DisconnectedBufferOptions disconnectedBufferOptions = new DisconnectedBufferOptions();
        disconnectedBufferOptions.setBufferEnabled(true);
        disconnectedBufferOptions.setBufferSize(100);
        disconnectedBufferOptions.setPersistBuffer(false);
        disconnectedBufferOptions.setDeleteOldestMessages(false);
        return disconnectedBufferOptions;
    }

    private void parseNotification(String pushNotification) {
        DeserializeMQTTNotification deserializeResult = new DeserializeMQTTNotification();
        PushInternal result = (PushInternal)deserializeResult.fromJson(pushNotification);
        Intent intentCustom = new Intent();
        switch (result.getCategory()) {
            case "kernel": {
                intentCustom.setAction(INTERNAL_FLYBITS_PUSH_SCOPE_KERNEL);
                break;
            }
            case "push": 
            case "custom": {
                intentCustom.setAction(INTERNAL_FLYBITS_PUSH_SCOPE_PUSH);
                break;
            }
            case "context": {
                intentCustom.setAction(INTERNAL_FLYBITS_PUSH_SCOPE_CONTEXT);
            }
        }
        intentCustom.putExtra(INTERNAL_FLYBITS_PUSH_DATA, result.getData());
        intentCustom.putExtra(INTERNAL_FLYBITS_PUSH_ACTION, result.getAction());
        intentCustom.putExtra(INTERNAL_FLYBITS_PUSH_ENTITY, result.getEntity());
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).sendBroadcast(intentCustom);
    }

    private void errorConnecting() {
        Logger.setTag(_TAG).d("errorConnecting");
        this.handler.removeCallbacks(this.runnableConnection);
        if (this.timeout < 256) {
            int randomNumber = this.rand.nextInt(this.timeout * 2) + this.timeout;
            this.handler.postDelayed(this.runnableConnection, (long)(randomNumber * 1000));
            this.timeout *= 2;
        }
    }

    public void onDestroy() {
        Logger.setTag("Testing").d("onDestroy()");
        this.handler.removeCallbacks(this.runnableConnection);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mSubscription);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mDisconnection);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mPublish);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mConnect);
    }
}

