package com.flybits.commons.library.models.internal;

import java.util.ArrayList;

public class QueryBuilder<T extends QueryBuilder>{

    public long limit;
    public long offset;
    public ArrayList<String> labels;

    /**
     * Default constructor to initializes all variables.
     */
    public QueryBuilder(){
        limit   = 0;
        offset  = -1;
        labels  = new ArrayList<>();
    }

    /**
     * Default constructor to initializes all variables.
     */
    public QueryBuilder(QueryParameters parameters){
        limit   = parameters.getLimit();
        offset  = parameters.getOffset();
        labels  = parameters.getLabels();
    }


    /**
     * Adds a constraint to the results, requiring them to have the given labels.
     *
     * @param labels The labels to filter by.
     */
    public T setLabels(String... labels)
    {
        if (labels != null) {
            this.labels.clear();
            for (String label : labels) {
                if (label != null)
                    this.labels.add(label);
            }
        }
        return (T) this;
    }

    /**
     * Adds a constraint to the results, requiring them to have the given labels.
     *
     * @param labels A list of labels to filter by.
     */
    public T setLabels(ArrayList<String> labels)
    {
        if (labels != null) {
            this.labels.clear();
            for (String label : labels)
                this.labels.add(label);
        }
        return (T) this;
    }

    /**
     * Adds a paging mechanism to the request based on the number of returned results wanted and
     * the offset of the next X number of results, where X is a limit.
     *
     * @param limit The maximum number of returned objects.
     * @param offset The offset of where the next X number of response objects will be returned
     *               from where X is the limit.
     */
    public T setPaging(long limit, long offset){
        this.limit  = limit;
        this.offset = offset;
        return (T) this;
    }
}