/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.analytics.AnalyticsOptions;
import com.flybits.commons.library.analytics.Properties;
import com.flybits.commons.library.api.Analytics;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.FlyJWT;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.idps.IDP;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ConnectionResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ConnectionResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.DeserializeLogin;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidFlybitsManagerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.internal.MQTTInstance;
import com.flybits.internal.db.CommonsDatabase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FlybitsManager {
    static final String AUTHENTICATION_API = "/sso/auth";
    static final String DISCONNECT_ENDPOINT = "/sso/auth/logout";
    static final String ME_ENDPOINT = "/sso/auth/me";
    public static boolean IS_DEBUG = false;
    private AnalyticsOptions analyticsOptions;
    private Context context;
    private boolean enableAnalytics;
    private IDP idProvider;
    private boolean isDebug;
    private ArrayList<String> languageCodes;
    private Set<FlybitsScope> listOfScopes;

    private FlybitsManager(Builder builder) {
        this.listOfScopes = builder.listOfScopes;
        this.context = builder.mContext;
        this.isDebug = builder.isDebug;
        this.enableAnalytics = builder.enableAnalytics;
        this.languageCodes = builder.languageCodes;
        this.idProvider = builder.idProvider;
        if (this.languageCodes.size() == 0) {
            this.languageCodes.add("en");
        }
        IS_DEBUG = this.isDebug;
        if (this.enableAnalytics) {
            this.analyticsOptions = builder.analyticsOptions != null ? builder.analyticsOptions : new AnalyticsOptions.Builder(this.context).setStorageType(AnalyticsOptions.StorageType.SQLITE_DB).setUploadServiceTime(60L, 60L, TimeUnit.HOURS).build();
        }
    }

    public static void setDebug() {
        IS_DEBUG = true;
    }

    public ConnectionResult connect(ConnectionResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ConnectionResult query = new ConnectionResult(this.context, callback, executorService);
        executorService.execute(() -> {
            if (this.idProvider == null) {
                throw new InvalidFlybitsManagerException("You must have an IDP set. This can be done through the setAccount(IDP) method");
            }
            try {
                boolean isConnnected;
                boolean bl = isConnnected = !SharedElements.getSavedJWTToken(this.context).equals("");
                if (isConnnected) {
                    Result getJWT = FlyJWT.refreshJWT(this.context);
                    if (getJWT.getStatus() == RequestStatus.COMPLETED) {
                        handler.post(() -> query.setConnected());
                        if (!Analytics.isInitialized() && this.enableAnalytics) {
                            Analytics.initialize(this.analyticsOptions);
                        }
                    } else if (getJWT.getStatus() == RequestStatus.NOT_CONNECTED) {
                        isConnnected = false;
                    } else {
                        handler.post(() -> query.setResult(getJWT));
                    }
                }
                if (!isConnnected) {
                    String body = this.idProvider.getRequestBody(this.context).toString();
                    String url = AUTHENTICATION_API + this.idProvider.getAuthenticationEndPoint();
                    Result<User> authenticatedUser = FlyAway.post(this.context, url, body, new DeserializeLogin(), "FlybitsManager.connect", User.class);
                    if (authenticatedUser.getStatus() == RequestStatus.COMPLETED) {
                        MQTTInstance.getInstance(this.context).connect(this.context);
                        CommonsDatabase.getDatabase(this.context).userDao().insert(authenticatedUser.getResult());
                        SharedElements.setConnectedIDP(this.context, this.idProvider.getProvider());
                        if (!Analytics.isInitialized() && this.enableAnalytics) {
                            Analytics.initialize(this.analyticsOptions);
                            Properties properties = new Properties();
                            properties.addProperty("idpType", this.idProvider.getClass().getCanonicalName());
                            Analytics.logEventFlybits("SDK - Connected", properties);
                        }
                        for (FlybitsScope scope : this.listOfScopes) {
                            scope.onConnected(authenticatedUser.getResult());
                        }
                    }
                    handler.post(() -> query.setResult(authenticatedUser));
                }
                SharedElements.setLocalization(this.context, this.languageCodes);
            }
            catch (FlybitsException e) {
                handler.post(() -> query.setFailed(e));
            }
        });
        return query;
    }

    public BasicResult destroy(BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult request = new BasicResult(this.context, callback, executorService);
        executorService.execute(() -> {
            try {
                if (Analytics.isInitialized()) {
                    Analytics.destroy(this.context);
                }
                String jwtToken = SharedElements.getSavedJWTToken(this.context);
                Result deleteUser = FlyAway.delete(this.context, ME_ENDPOINT, "FlybitsManager.destroy", null);
                if (deleteUser.getStatus() == RequestStatus.COMPLETED) {
                    FlybitsManager.clearUserInformation(this.context);
                    CommonsDatabase.getDatabase(this.context).userDao().delete();
                    for (FlybitsScope scope : this.listOfScopes) {
                        scope.onAccountDestroyed(jwtToken);
                    }
                }
                handler.post(() -> request.setResult(deleteUser));
            }
            catch (FlybitsException e) {
                handler.post(() -> request.setFailed(e));
            }
        });
        return request;
    }

    public BasicResult disconnect(BasicResultCallback callback) {
        return this.disconnect(callback, false);
    }

    public BasicResult disconnect(BasicResultCallback callback, boolean disconnectOnException) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult request = new BasicResult(this.context, callback, executorService);
        executorService.execute(() -> {
            try {
                if (!Analytics.isInitialized()) {
                    Analytics.destroy(this.context);
                }
                String jwtToken = SharedElements.getSavedJWTToken(this.context);
                Result disconnected = FlyAway.post(this.context, DISCONNECT_ENDPOINT, "", null, "FlybitsManager.disconnect", null);
                if (disconnected.getStatus() == RequestStatus.COMPLETED || disconnectOnException) {
                    FlybitsManager.clearUserInformation(this.context);
                    CommonsDatabase.getDatabase(this.context).userDao().delete();
                }
                if (disconnected.getStatus() == RequestStatus.COMPLETED) {
                    if (Analytics.isInitialized()) {
                        Analytics.logEventFlybits("SDK - Disconnected", null);
                    }
                    for (FlybitsScope scope : this.listOfScopes) {
                        scope.onDisconnected(jwtToken);
                    }
                }
                handler.post(() -> request.setResult(disconnected));
            }
            catch (FlybitsException e) {
                if (disconnectOnException) {
                    FlybitsManager.clearUserInformation(this.context);
                    CommonsDatabase.getDatabase(this.context).userDao().delete();
                }
                handler.post(() -> request.setFailed(e));
            }
        });
        return request;
    }

    public static ObjectResult<User> getUser(Context context, ObjectResultCallback<User> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ObjectResult<User> request = new ObjectResult<User>(context, callback, executorService);
        executorService.execute(() -> {
            try {
                Result<User> getUser = FlyAway.get(context, ME_ENDPOINT, new DeserializeLogin(), "FlybitsManager.get", User.class);
                handler.post(() -> request.setResult(getUser));
            }
            catch (FlybitsException e) {
                handler.post(() -> request.setFailed(e));
            }
        });
        return request;
    }

    public static ObjectResult<User> getUser(Context context) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ObjectResult<User> request = new ObjectResult<User>(context, null, executorService);
        executorService.execute(() -> {
            try {
                Result<User> getUser = FlyAway.get(context, ME_ENDPOINT, new DeserializeLogin(), "FlybitsManager.get", User.class);
                if (getUser.getStatus() == RequestStatus.COMPLETED) {
                    CommonsDatabase.getDatabase(context).userDao().update(getUser.getResult());
                }
                handler.post(() -> request.setResult(getUser));
            }
            catch (FlybitsException e) {
                handler.post(() -> request.setFailed(e));
            }
        });
        return request;
    }

    public static ConnectionResult isConnected(@NonNull Context context, boolean confirmThroughNetwork, @NonNull ConnectionResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ConnectionResult query = new ConnectionResult(context, callback, executorService);
        executorService.execute(() -> {
            if (confirmThroughNetwork && !SharedElements.getSavedJWTToken(context).equals("")) {
                try {
                    Result getJWT = FlyJWT.refreshJWT(context);
                    handler.post(() -> {
                        if (getJWT.getStatus() == RequestStatus.NOT_CONNECTED) {
                            callback.notConnected();
                        } else if (getJWT.getStatus() == RequestStatus.COMPLETED) {
                            callback.onConnected();
                        } else {
                            callback.onException(getJWT.getException());
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(() -> callback.onException(e));
                }
            } else if (SharedElements.getSavedJWTToken(context).equals("")) {
                handler.post(() -> callback.notConnected());
            } else {
                handler.post(() -> callback.onConnected());
            }
        });
        return query;
    }

    static void clearUserInformation(Context context) {
        MQTTInstance.getInstance(context).disconnect(context);
        SharedPreferences preferences = SharedElements.getPreferences(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.clear();
        editor.apply();
    }

    IDP getIDP() {
        return this.idProvider;
    }

    Set<FlybitsScope> getScopes() {
        return this.listOfScopes;
    }

    boolean isDebug() {
        return this.isDebug;
    }

    boolean isAnalyticsEnabled() {
        return this.enableAnalytics;
    }

    public static final class Builder {
        private final Set<FlybitsScope> listOfScopes;
        private Context mContext;
        private IDP idProvider;
        private boolean isDebug;
        private boolean enableAnalytics;
        private AnalyticsOptions analyticsOptions;
        private ArrayList<String> languageCodes;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.listOfScopes = new HashSet<FlybitsScope>();
            this.languageCodes = new ArrayList();
            try {
                this.languageCodes.add(Locale.getDefault().getLanguage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Builder addScope(@NonNull FlybitsScope scope) {
            this.listOfScopes.add(scope);
            return this;
        }

        public FlybitsManager build() throws InvalidFlybitsManagerException {
            this.checkIfFieldsSet();
            return new FlybitsManager(this);
        }

        public Builder enableAnalytics() {
            this.enableAnalytics = true;
            return this;
        }

        public Builder overrideAnalyticsOptions(AnalyticsOptions options) {
            this.analyticsOptions = options;
            return this.enableAnalytics();
        }

        public Builder setAccount(IDP idp) {
            this.idProvider = idp;
            return this;
        }

        public Builder setDebug() {
            this.isDebug = true;
            return this;
        }

        public Builder setLanguage(@NonNull String languageCode) {
            this.languageCodes.clear();
            this.languageCodes.add(languageCode);
            return this;
        }

        private void checkIfFieldsSet() throws InvalidFlybitsManagerException {
            Properties properties = new Properties();
            if (this.listOfScopes.size() == 0) {
                if (Analytics.isInitialized()) {
                    Analytics.logEventFlybits("Missing Scope", properties);
                }
                throw new InvalidFlybitsManagerException("You must have at least 1 scope set to create a valid FlybitsManager object");
            }
            if (this.languageCodes.size() != 1 && this.languageCodes.get(0).length() != 2) {
                if (Analytics.isInitialized()) {
                    Analytics.logEventFlybits("Invalid Language Code", properties);
                }
                throw new InvalidFlybitsManagerException("Your language must be a 2-letter code. Make sure you call setLanguage(String)");
            }
        }
    }
}

