/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.analytics.AnalyticsBundle;
import com.flybits.commons.library.analytics.AnalyticsOptions;
import com.flybits.commons.library.analytics.Properties;
import com.flybits.commons.library.analytics.UploadChannel;
import com.flybits.commons.library.analytics.services.AnalyticsUploadService;
import com.flybits.commons.library.analytics.storage.MemoryStorage;
import com.flybits.commons.library.analytics.storage.QueueStorage;
import com.flybits.commons.library.analytics.storage.sql.SqliteStorage;
import com.flybits.commons.library.api.FlybitsUploadChannel;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.utils.Utilities;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.PeriodicTask;
import com.google.android.gms.gcm.Task;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Analytics {
    public static final String _TAG = "Analytics";
    public static final String PREFS_STORAGETYPE = "fbanalytics_storagetype";
    public static final String PREFS_CUSTOMDEVICEID = "fbanalytics_customdeviceid";
    private static Analytics mInstance;
    private Context mContext;
    private Map<Integer, AnalyticsBundle> mCurrentTimedEvents;
    private QueueStorage mQueueStorage;
    private String mCustomDeviceId;
    private FlybitsUploadChannel mFlybitsUploadChannel = new FlybitsUploadChannel();
    private boolean mIsShutdown = false;
    private ExecutorService mFlushExecutorService;

    private Analytics(AnalyticsOptions options) {
        this.mCurrentTimedEvents = new LinkedHashMap<Integer, AnalyticsBundle>();
        this.mContext = options.getContext();
        SharedPreferences preferences = SharedElements.getPreferences(this.mContext);
        this.mCustomDeviceId = options.getCustomDeviceId();
        preferences.edit().putString(PREFS_CUSTOMDEVICEID, this.mCustomDeviceId).apply();
        if (options.getStorageType() == AnalyticsOptions.StorageType.SQLITE_DB) {
            this.mQueueStorage = new SqliteStorage(this.mContext);
            if (this.mQueueStorage == null) {
                Logger.setTag(_TAG).e("Error creating SQliteDB. Resorting to memory storage.");
                this.mQueueStorage = new MemoryStorage();
            }
        } else {
            this.mQueueStorage = options.getStorageType() == AnalyticsOptions.StorageType.BINARY ? new MemoryStorage() : new MemoryStorage();
        }
        preferences.edit().putString(PREFS_STORAGETYPE, options.getStorageType().getValue()).apply();
        if (options.getDataFlushTime() != -1L) {
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)this.mContext);
            PeriodicTask.Builder task = new PeriodicTask.Builder().setService(AnalyticsUploadService.class).setTag("FBAnalyticsUploadService").setPersisted(true).setPeriod(options.getDataFlushTime()).setFlex(options.getDataFlushTimeFlex()).setRequiredNetwork(2).setUpdateCurrent(true);
            mGcmNetworkManager.schedule((Task)task.build());
        }
    }

    private ExecutorService flush(Context context) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(() -> {
            if (this.mFlybitsUploadChannel == null) {
                this.mFlybitsUploadChannel = new FlybitsUploadChannel();
            }
            this.flushNonThreaded(context, this.mFlybitsUploadChannel);
        });
        this.mFlushExecutorService = executorService;
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushNonThreaded(Context context, UploadChannel channel) {
        boolean isOnInit;
        String deviceId = mInstance.getDeviceId();
        String projectId = SharedElements.getProjectID(this.mContext);
        if (deviceId == null || deviceId.isEmpty()) {
            Logger.setTag(_TAG).e("Analytics: There was an issue getting the device id. Flush aborted!");
            return;
        }
        if (this.mIsShutdown) {
            return;
        }
        if (!this.mFlybitsUploadChannel.isAuthed() && !(isOnInit = this.mFlybitsUploadChannel.onInit(context))) {
            return;
        }
        if (this.mIsShutdown) {
            return;
        }
        if (!this.mFlybitsUploadChannel.isAuthed()) {
            Logger.setTag(_TAG).e("Analytics: Cannot authenticate with Flybits. Aborting!");
            return;
        }
        QueueStorage queueStorage = Analytics.mInstance.mQueueStorage;
        synchronized (queueStorage) {
            AnalyticsBundle[] bundles = this.mQueueStorage.getAll();
            if (bundles.length == 0) {
                Logger.setTag(_TAG).i(String.format("No events to flush for channel %s", channel.getName()));
                return;
            }
            Logger.setTag(_TAG).i(String.format("Starting flush of %d events to channel `%s`", bundles.length, channel.getName()));
            boolean result = channel.onUpload(context, deviceId, projectId, bundles);
            if (result) {
                this.mQueueStorage.remove(bundles.length);
                Logger.setTag(_TAG).i(String.format("Flush completed successfully", bundles.length));
            } else {
                Logger.setTag(_TAG).i(String.format("Flush failed", bundles.length));
            }
        }
    }

    void instanceDestroy() {
        this.mIsShutdown = true;
        if (this.mFlushExecutorService != null && !this.mFlushExecutorService.isShutdown()) {
            this.mFlushExecutorService.shutdown();
        }
    }

    private String getDeviceId() {
        if (this.mCustomDeviceId == null && SharedElements.getPreferences(this.mContext).contains(PREFS_CUSTOMDEVICEID)) {
            this.mCustomDeviceId = SharedElements.getPreferences(this.mContext).getString(PREFS_CUSTOMDEVICEID, null);
        }
        if (this.mCustomDeviceId != null) {
            return this.mCustomDeviceId;
        }
        if (!SharedElements.getDeviceID(this.mContext).equals("")) {
            return SharedElements.getDeviceID(this.mContext);
        }
        return Utilities.getDeviceID(this.mContext);
    }

    static void initialize(@NonNull AnalyticsOptions options) {
        mInstance = new Analytics(options);
    }

    static void destroy(Context context) {
        try {
            GcmNetworkManager gcmNetworkManager = GcmNetworkManager.getInstance((Context)context);
            gcmNetworkManager.cancelTask("FBAnalyticsUploadService", AnalyticsUploadService.class);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            Logger.exception("Analytics.destroy", ex);
        }
        if (Analytics.isInitialized()) {
            mInstance.flushNonThreaded(context, Analytics.mInstance.mFlybitsUploadChannel);
            mInstance.instanceDestroy();
        }
    }

    public static void logEvent(@NonNull String eventName) {
        Analytics.logEvent(eventName, null);
    }

    public static void logEvent(@NonNull String eventName, Properties properties) {
        if (!Analytics.isInitialized()) {
            Logger.setTag(_TAG).w("Logging of Analytics could not be completed. Please make sure that you have connected to Flybits using the FlybitsManager.connect() method.");
            return;
        }
        AnalyticsBundle.Builder bundle = new AnalyticsBundle.Builder(eventName).setAppProperties(properties);
        Analytics.logEventInternal(eventName, bundle);
    }

    public static void logEventFlybits(@NonNull String eventName, Properties properties) {
        if (!Analytics.isInitialized()) {
            Logger.setTag(_TAG).w("Logging of Analytics could not be completed. Please make sure that you have connected to Flybits using the FlybitsManager.connect() method.");
            return;
        }
        AnalyticsBundle.Builder bundle = new AnalyticsBundle.Builder(eventName).setAppProperties(properties).setFlybitsEvent();
        Analytics.logEventInternal(eventName, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logEventInternal(String eventName, AnalyticsBundle.Builder bundle) {
        if (!TextUtils.isEmpty((CharSequence)SharedElements.getUserID(Analytics.mInstance.mContext))) {
            bundle.setUserID(SharedElements.getUserID(Analytics.mInstance.mContext));
        }
        AnalyticsBundle analyticsBundle = bundle.build();
        Log.d((String)"Tesing", (String)("userID: " + analyticsBundle.getUserID()));
        QueueStorage queueStorage = Analytics.mInstance.mQueueStorage;
        synchronized (queueStorage) {
            Analytics.mInstance.mQueueStorage.add(analyticsBundle);
            Logger.setTag(_TAG).i(String.format("Event \"%s\" @ time \"%d\" saved to storage.", eventName, analyticsBundle.getTimestamp()));
        }
    }

    public static int startTimedEvent(@NonNull String eventName) {
        return Analytics.startTimedEvent(eventName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int startTimedEvent(@NonNull String eventName, Properties properties) {
        if (!Analytics.isInitialized()) {
            Logger.setTag(_TAG).w("Logging of Analytics could not be completed. Please make sure that you have connected to Flybits using the FlybitsManager.connect() method.");
            return -1;
        }
        if (properties == null) {
            properties = new Properties();
        }
        long timestamp = Calendar.getInstance().getTimeInMillis();
        int hash = (eventName + "|" + timestamp).hashCode();
        AnalyticsBundle.Builder bundle = new AnalyticsBundle.Builder(eventName, AnalyticsBundle.EventType.START_TIME_EVENT, String.valueOf(hash)).setAppProperties(properties);
        if (!TextUtils.isEmpty((CharSequence)SharedElements.getUserID(Analytics.mInstance.mContext))) {
            bundle.setUserID(SharedElements.getUserID(Analytics.mInstance.mContext));
        }
        AnalyticsBundle analyticsBundle = bundle.build();
        Analytics.mInstance.mCurrentTimedEvents.put(hash, analyticsBundle);
        QueueStorage queueStorage = Analytics.mInstance.mQueueStorage;
        synchronized (queueStorage) {
            Analytics.mInstance.mQueueStorage.add(analyticsBundle);
        }
        Logger.setTag(_TAG).i(String.format("Timed event \"%s\" started @ time \"%d\".", eventName, analyticsBundle.getTimestamp()));
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean endTimedEvent(int reference) {
        if (!Analytics.isInitialized()) {
            Logger.setTag(_TAG).e("Logging of Analytics could not be completed. Please make sure that you have connected to Flybits using the FlybitsManager.connect() method.");
            return false;
        }
        if (Analytics.mInstance.mCurrentTimedEvents.containsKey(reference)) {
            AnalyticsBundle startBundle = Analytics.mInstance.mCurrentTimedEvents.get(reference);
            long endTime = Calendar.getInstance().getTimeInMillis();
            AnalyticsBundle.Builder bundle = new AnalyticsBundle.Builder(startBundle.getEventName(), AnalyticsBundle.EventType.END_TIME_EVENT, String.valueOf(reference));
            if (!TextUtils.isEmpty((CharSequence)SharedElements.getUserID(Analytics.mInstance.mContext))) {
                bundle.setUserID(SharedElements.getUserID(Analytics.mInstance.mContext));
            }
            AnalyticsBundle analyticsBundle = bundle.build();
            Analytics.mInstance.mCurrentTimedEvents.remove(reference);
            QueueStorage queueStorage = Analytics.mInstance.mQueueStorage;
            synchronized (queueStorage) {
                Analytics.mInstance.mQueueStorage.add(analyticsBundle);
            }
            Logger.setTag(_TAG).i(String.format("Event \"%s\" ended at \"%d\".", startBundle.getEventName(), endTime));
            return true;
        }
        Logger.setTag(_TAG).w("Warning: Called `endTimedEvent` on an unknown reference id");
        return false;
    }

    public static ExecutorService flushEvents(@NonNull Context context) {
        if (!Analytics.isInitialized()) {
            Logger.setTag(_TAG).e("Logging of Analytics could not be completed. Please make sure that you have connected to Flybits using the FlybitsManager.connect() method.");
            return null;
        }
        return mInstance.flush(context);
    }

    public static boolean isInitialized() {
        return mInstance != null;
    }

    public static void networkFailure(String url, String reason, Properties properties) {
        properties.addProperty("apiRequest", url);
        properties.addProperty("reason", reason);
        Analytics.logEventFlybits("Error - Network", properties);
    }

    public static void deserializationFailure(String apiRequest, Properties properties) {
        properties.addProperty("apiRequest", apiRequest);
        Analytics.logEventFlybits("Error - Deserialization", properties);
    }
}

