/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class Utilities {
    public static ArrayList<String> convertLocalizationStringToList(String languageCodeAsString) {
        if (languageCodeAsString == null || languageCodeAsString.length() == 0) {
            return new ArrayList<String>();
        }
        String[] listOfCodes = languageCodeAsString.split(",");
        return new ArrayList<String>(Arrays.asList(listOfCodes));
    }

    public static String convertLocalizationCodeToString(ArrayList<String> listOfCodes) {
        if (listOfCodes != null && listOfCodes.size() > 0) {
            String languageCodeString = listOfCodes.get(0);
            for (int i = 1; i < listOfCodes.size(); ++i) {
                languageCodeString = languageCodeString.concat("," + listOfCodes.get(i));
            }
            return languageCodeString;
        }
        return "";
    }

    public static String getDeviceID(@NonNull Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getSDKVersion() {
        return "0.3.2";
    }

    public static String getUserAgentAsJSON(Context context) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("make", (Object)Build.MANUFACTURER);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("model", (Object)Build.MODEL);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("osVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("deviceType", (Object)"Android");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("physicalDeviceId", (Object)Utilities.getDeviceID(context));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("sdkVersion", (Object)Utilities.getSDKVersion());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return obj.toString();
    }
}

