/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QueryParameters {
    private long limit;
    private long offset;
    private ArrayList<String> labels;

    public QueryParameters(QueryBuilder builder) {
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.labels = builder.labels;
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        if (this.limit > 0L && this.offset > -1L) {
            ArrayList<String> limitParam = new ArrayList<String>();
            limitParam.add(String.valueOf(this.limit));
            params.put("limit", limitParam);
            ArrayList<String> offsetParam = new ArrayList<String>();
            offsetParam.add(String.valueOf(this.offset));
            params.put("offset", offsetParam);
        }
        if (this.labels.size() > 0) {
            ArrayList<String> labelsParam = new ArrayList<String>();
            labelsParam.addAll(this.labels);
            params.put("labels", labelsParam);
        }
        return params;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public ArrayList<String> getLabels() {
        return this.labels;
    }

    public static class QueryBuilder {
        private long limit;
        private long offset;
        private ArrayList<String> labels;

        public QueryBuilder() {
            this.limit = 0L;
            this.offset = -1L;
            this.labels = new ArrayList();
        }

        public QueryBuilder(QueryParameters parameters) {
            this.limit = parameters.getLimit();
            this.offset = parameters.getOffset();
            this.labels = parameters.getLabels();
        }

        public QueryBuilder setLabels(String ... labels) {
            if (labels != null) {
                this.labels.clear();
                for (String label : labels) {
                    if (label == null) continue;
                    this.labels.add(label);
                }
            }
            return this;
        }

        public QueryBuilder setLabels(ArrayList<String> labels) {
            if (labels != null) {
                this.labels.clear();
                for (String label : labels) {
                    this.labels.add(label);
                }
            }
            return this;
        }

        public QueryBuilder setPaging(long limit, long offset) {
            this.limit = limit;
            this.offset = offset;
            return this;
        }

        public QueryParameters build() {
            return new QueryParameters(this);
        }
    }
}

