/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.caching;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class FlybitsCacheLoader<T> {
    private CacheLoader callback;
    private ExecutorService executorService;

    public abstract List<T> load();

    public void get(final CacheLoader<T> callback) {
        this.callback = callback;
        final Handler handler = new Handler(Looper.getMainLooper());
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                final List loadedList = FlybitsCacheLoader.this.load();
                if (callback != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (loadedList != null) {
                                callback.onLoad(loadedList);
                            } else {
                                callback.onLoad(new ArrayList());
                            }
                        }
                    });
                }
            }
        });
    }

    public void cancel() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
            if (this.callback != null) {
                this.callback.onCancel();
            }
        }
    }

    public static interface CacheLoader<T> {
        public void onCancel();

        public void onLoad(List<T> var1);
    }
}

