/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics.converter;

import com.flybits.commons.library.analytics.AnalyticsBundle;
import com.flybits.commons.library.analytics.Properties;
import com.flybits.commons.library.analytics.converter.Converter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonConverter
implements Converter<String> {
    private final String ATTRIBUTE_NAME = "name";
    private final String ATTRIBUTE_LOGGED_AT = "loggedAt";
    private final String ATTRIBUTE_TYPE = "type";
    private final String ATTRIBUTE_APP_PROPERTIES = "properties";
    private final String ATTRIBUTE_FLB_PROPERTIES = "flbProperties";
    private final String ATTRIBUTE_IS_FLB = "isFlybits";

    @Override
    public String to(AnalyticsBundle[] bundles) throws JSONException {
        JSONArray rootArray = new JSONArray();
        for (AnalyticsBundle bundle : bundles) {
            JSONObject bundleObj = new JSONObject();
            Properties properties = bundle.getAppProperties();
            JSONObject propertyObject = new JSONObject(properties.toJSON());
            Properties flbProperties = bundle.getFlybitsProperties();
            JSONObject flbpropertyObject = new JSONObject(flbProperties.toJSON());
            bundleObj.put("name", (Object)bundle.getEventName());
            bundleObj.put("loggedAt", bundle.getTimestamp());
            bundleObj.put("type", (Object)bundle.getType().getValue());
            bundleObj.put("properties", (Object)propertyObject);
            bundleObj.put("flbProperties", (Object)flbpropertyObject);
            bundleObj.put("isFlybits", bundle.isFlybits());
            rootArray.put((Object)bundleObj);
        }
        return rootArray.toString();
    }

    @Override
    public AnalyticsBundle[] from(String data) throws JSONException {
        JSONArray rootArray = new JSONArray(data);
        int size = rootArray.length();
        AnalyticsBundle[] bundles = new AnalyticsBundle[size];
        for (int i = 0; i < size; ++i) {
            AnalyticsBundle.Builder event;
            AnalyticsBundle.EventType type;
            JSONObject bundleObj = rootArray.getJSONObject(i);
            if (!bundleObj.has("name") || !bundleObj.has("loggedAt") || !bundleObj.has("type") || !bundleObj.has("properties")) continue;
            String name = bundleObj.getString("name");
            long timestamp = bundleObj.getLong("loggedAt");
            boolean isFlybits = bundleObj.getBoolean("isFlybits");
            String typeString = bundleObj.getString("type");
            Properties properties = new Properties();
            if (bundleObj.has("flbProperties")) {
                properties = new Properties(bundleObj.getJSONObject("properties").toString());
            }
            Properties flbProperties = new Properties();
            if (bundleObj.has("flbProperties")) {
                flbProperties = new Properties(bundleObj.getJSONObject("flbProperties").toString());
            }
            if ((type = AnalyticsBundle.EventType.fromValue(typeString)) == AnalyticsBundle.EventType.DISCRETE_EVENT) {
                event = new AnalyticsBundle.Builder(name);
                if (flbProperties.getMap().containsKey("uid")) {
                    event.setUserID((String)flbProperties.getMap().get("uid"));
                }
            } else {
                if (type != AnalyticsBundle.EventType.END_TIME_EVENT && type != AnalyticsBundle.EventType.START_TIME_EVENT || !flbProperties.getMap().containsKey("timedRef")) break;
                event = new AnalyticsBundle.Builder(name, type, flbProperties.getMap().get("timedRef").toString());
                if (flbProperties.getMap().containsKey("uid")) {
                    event.setUserID((String)flbProperties.getMap().get("uid"));
                }
            }
            event.setCustomTimestamp(timestamp).setAppProperties(properties);
            if (isFlybits) {
                event.setFlybitsEvent();
            }
            bundles[i] = event.build();
        }
        return bundles;
    }
}

