/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics;

import android.support.annotation.NonNull;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class SquishyFormat {
    public static final int DATATYPE_NUMBER = 0;
    public static final int DATATYPE_FLOATNUMBER = 1;
    public static final int DATATYPE_STRING = 2;
    public static final int DATATYPE_BOOLEAN_FALSE = 4;
    public static final int DATATYPE_BOOLEAN_TRUE = 3;
    public static final int DATATYPE_NULL = 5;
    public static final int DATATYPE_MAP = 6;
    public static final int DATATYPE_ARRAY = 7;
    public static final int FLAG_BYTE_STRIPPING = 0;
    private ByteArrayOutputStream mOutputByteArray = new ByteArrayOutputStream(size += 16);
    private boolean mIsByteStripping = true;

    private SquishyFormat() throws IOException {
        this(32);
    }

    private SquishyFormat(int size) throws IOException {
        this.mOutputByteArray.write(new byte[]{70, 105, 108, 77}, 0, 4);
        this.mOutputByteArray.write(new byte[]{1, 0});
        short flags = 0;
        flags = (short)(flags | (this.mIsByteStripping ? 1 : 0) << 0);
        this.mOutputByteArray.write(ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(flags).array());
        for (int i = 0; i < 8; ++i) {
            this.mOutputByteArray.write(0);
        }
    }

    public static SquishyFormat begin() throws IOException {
        return new SquishyFormat();
    }

    public static SquishyFormat begin(int size) throws IOException {
        return new SquishyFormat(size);
    }

    public byte[] end() {
        return this.mOutputByteArray.toByteArray();
    }

    public String endAsBase64() {
        byte[] encoded = Base64.encode((byte[])this.mOutputByteArray.toByteArray(), (int)0);
        return new String(encoded);
    }

    public void writeNumber(long value) throws IOException {
        byte[] bytes = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(value).array();
        int numBytes = this.countNonZeroBytes(bytes);
        this.mOutputByteArray.write(numBytes << 4 | 0);
        if (this.mIsByteStripping) {
            this.mOutputByteArray.write(bytes, 0, numBytes);
        } else {
            this.mOutputByteArray.write(bytes);
        }
    }

    public void writeFNumber(double value) throws IOException {
        byte[] bytes = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(value).array();
        int numBytes = this.countNonZeroBytes(bytes);
        this.mOutputByteArray.write(numBytes << 4 | 1);
        if (this.mIsByteStripping) {
            this.mOutputByteArray.write(bytes, 0, numBytes);
        } else {
            this.mOutputByteArray.write(bytes);
        }
    }

    public void writeString(@NonNull String value) throws IOException {
        byte[] bytes = value.getBytes();
        this.mOutputByteArray.write(2);
        this.mOutputByteArray.write(bytes);
        this.mOutputByteArray.write(0);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.mOutputByteArray.write(value ? 3 : 4);
    }

    public void writeNull() throws IOException {
        this.mOutputByteArray.write(5);
    }

    public void writeArray(@NonNull Object[] array) throws IOException {
        this.mOutputByteArray.write(7);
        this.mOutputByteArray.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(array.length).array());
        for (int i = 0; i < array.length; ++i) {
            this.write(array[i]);
        }
    }

    public void writeMap(@NonNull Map map) throws IOException {
        this.mOutputByteArray.write(6);
        this.mOutputByteArray.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(map.size()).array());
        for (Object key : map.keySet()) {
            this.write(key);
            this.write(map.get(key));
        }
    }

    private void write(Object o) throws IOException {
        if (o instanceof String) {
            this.writeString((String)o);
        } else if (o instanceof Integer) {
            this.writeNumber(((Integer)o).intValue());
        } else if (o instanceof Long) {
            this.writeNumber((Long)o);
        } else if (o instanceof Boolean) {
            this.writeBoolean((Boolean)o);
        } else {
            this.writeString(o.toString());
        }
    }

    private int countNonZeroBytes(byte[] value) {
        int numZeros = 0;
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == 0) {
                ++numZeros;
                continue;
            }
            numZeros = 0;
        }
        return value.length - numZeros;
    }
}

