package com.flybits.commons.library.api.idps;


import org.json.JSONObject;

/**
 * The {@code AnonymousIDP} class is responsible for logging into the Flybits system anonymously
 * without having to enter any additional information. This IDP is the default IDP for the Android
 * SDK. It can be overridden by other IDPs such as {@link FlybitsIDP}.
 */
public class AnonymousIDP extends IDP{

    private static final String ENDPOINT       = "/anonymous";

    /**
     * Constructor used to register an anonymous account to the Flybits system.
     */
    public AnonymousIDP(){
        super ("anonymous");
    }

    @Override
    public String getAuthenticationEndPoint() {
        return ENDPOINT;
    }

    @Override
    public JSONObject getBody() {
        return null;
    }
}
