package com.flybits.commons.library.analytics.storage;

import com.flybits.commons.library.analytics.AnalyticsBundle;

/**
 * The {@code QueueStorage} interface abstracts the queued storage that the Analytics SDK uses to
 * store event data before it will be flushed. This allows for different storing methods to be implemented
 * without changing the core code.
 */
public interface QueueStorage {

    /**
     * Queues a {@link AnalyticsBundle} to storage.
     * @param bundle The {@link AnalyticsBundle} to be queued.
     */
    void add(AnalyticsBundle bundle);

    /**
     * Gets the next {@link AnalyticsBundle} in the queue.
     * @return The next {@link AnalyticsBundle} in the queue.
     */
    AnalyticsBundle getNext();

    /**
     * Get's all queued {@link AnalyticsBundle} objects in queued order.
     * @return An array of {@link AnalyticsBundle} objects in the queued order.
     */
    AnalyticsBundle[] getAll();

    /**
     * Removes {@link AnalyticsBundle} objects from the queue in queue order.
     * @param count The number of objects to remove.
     */
    void remove(int count);

    /**
     * Gets the current count of {@link AnalyticsBundle} objects in the queue.
     * @return The number of {@link AnalyticsBundle} objects in the queue.
     */
    int size();

}
