package com.flybits.commons.library.analytics.storage;

import com.flybits.commons.library.analytics.AnalyticsBundle;

import java.util.ArrayList;

/**
 * This is a memory implementation of the {@link QueueStorage}. Objects are stored in an arraylist
 * and are added/removed in FIFO order.
 */
public class MemoryStorage implements QueueStorage {

    private ArrayList<AnalyticsBundle> mStorage = new ArrayList<>();

    /**
     * Adds a serialized {@link AnalyticsBundle} to the queue.
     * @param bundle The bundle to be queued up.
     */
    @Override
    public void add(AnalyticsBundle bundle) {
        if (bundle != null)
            mStorage.add(bundle);
    }

    /**
     * Gets the next {@link AnalyticsBundle} from the queue.
     * @return The next {@link AnalyticsBundle} in the queue.
     */
    @Override
    public AnalyticsBundle getNext() {
        if (mStorage.size() == 0)
            return null;
        AnalyticsBundle bundle = mStorage.get(0);
        return bundle;
    }

    /**
     * Gets all the next {@link AnalyticsBundle}s from the queue.
     * @return A list of {@link AnalyticsBundle}s sorted by order retrieved from the queue.
     */
    @Override
    public AnalyticsBundle[] getAll() {
        if (mStorage.size() == 0)
            return new AnalyticsBundle[0];
        AnalyticsBundle[] bundleList = new AnalyticsBundle[mStorage.size()];
        mStorage.toArray(bundleList);
        return bundleList;
    }

    /**
     * Removes {@link AnalyticsBundle}s from the queue, up to count.
     */
    @Override
    public void remove(int count) {
        int max = (mStorage.size() < count ? mStorage.size() : count);
        for (int i = 0; i < max; i++)
        {
            mStorage.remove(0);
        }
    }

    /**
     * Gets the amount of {@link AnalyticsBundle}s in the queue.
     * @return The amount of queued {@link AnalyticsBundle}s.
     */
    @Override
    public int size() {
        return mStorage.size();
    }

}