/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;

public abstract class PagedResult<T>
extends FlybitsResult {
    private long currentOffset = 0L;
    private long totalItems = 0L;
    private long limit = 0L;
    private PagedResultCallback<T> callback;
    private QueryParameters parameters;

    public PagedResult(@NonNull Context context, PagedResultCallback<T> callback) {
        super(context);
        this.callback = callback;
    }

    public PagedResult(@NonNull Context context, PagedResultCallback<T> callback, @NonNull ExecutorService service) {
        super(context, service);
        this.callback = callback;
    }

    public PagedResult getMore(PagedResultCallback<T> callback) {
        if (this.hasMore()) {
            this.getParameters().addPaging(this.limit, this.currentOffset);
            return this.getMore(this.getContext(), this.getParameters(), callback);
        }
        if (callback != null) {
            callback.onLoadedAllItems();
        }
        return this;
    }

    public QueryParameters getParameters() {
        return this.parameters;
    }

    public boolean hasMore() {
        return this.currentOffset < this.totalItems;
    }

    @Override
    public boolean setFailed(FlybitsException e) {
        if (super.setFailed(e)) {
            if (this.callback != null) {
                this.callback.onException(e);
            }
            return true;
        }
        return false;
    }

    protected void setSuccess(QueryParameters parameters, @NonNull ArrayList<T> items, @NonNull Pagination pagination) {
        this.parameters = parameters;
        this.limit = pagination.getLimit();
        this.totalItems = pagination.getTotalRecords();
        long l = this.currentOffset = items != null ? pagination.getOffset() + (long)items.size() : 0L;
        if (this.setSuccess() && items != null && this.callback != null) {
            this.callback.onSuccess(items);
            if (!this.hasMore()) {
                this.callback.onLoadedAllItems();
            }
        }
    }

    public void setResult(@NonNull Result<PagedResponse<T>> result, QueryParameters params) {
        if (result.getStatus() == RequestStatus.COMPLETED && result.getResult() != null) {
            this.setSuccess(params, result.getResult().getItems(), result.getResult().getPagination());
        } else {
            this.setFailed(result.getException());
        }
    }

    protected abstract <K extends QueryParameters> PagedResult getMore(Context var1, K var2, PagedResultCallback<T> var3);
}

