/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyJWT;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.exceptions.FlybitsDisabledException;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.internal.DeserializeMQTTNotification;
import com.flybits.internal.PushInternal;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.paho.android.service.MqttAndroidClient;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class FlybitsMQTTService
extends Service {
    static final String INTERNAL_FLYBITS_PUSH_SCOPE_KERNEL = "com.flybits.action.push.scope.kernel";
    static final String INTERNAL_FLYBITS_PUSH_SCOPE_PUSH = "com.flybits.action.push.scope.push";
    static final String INTERNAL_FLYBITS_PUSH_SCOPE_CONTEXT = "com.flybits.action.push.scope.context";
    static final String INTERNAL_FLYBITS_PUSH_DATA = "com.flybits.action.push.param.data";
    static final String INTERNAL_FLYBITS_PUSH_ACTION = "com.flybits.action.push.param.action";
    static final String INTERNAL_FLYBITS_PUSH_ENTITY = "com.flybits.action.push.param.entity";
    private final int MINTIMEOUT = 1;
    private final int MAXTIMEOUT = 256;
    private int timeout = 1;
    public static final String MQTT_SUBSCRIBE = "mqtt-subscribe";
    public static final String MQTT_DISCONNECT = "mqtt-disconnect";
    public static final String MQTT_PUBLISH = "mqtt-publish";
    public static final String IS_SUBSCRIBE = "mqtt-event:IS_SUBSCRIBE";
    public static final String TOPICS = "topics";
    private Handler handler;
    private Vector<String> topics;
    private Random rand;
    private static final int QOS_WILL = 1;
    private static final int QOS = 0;
    private static final int KEEP_ALIVE = 30;
    private static final String _TAG = "FlybitsMQTTService";
    private MqttAndroidClient client;
    private MqttCallbackExtended callback = new MqttCallbackExtended(){

        public void connectComplete(boolean b, String s) {
        }

        public void connectionLost(Throwable cause) {
            Log.d((String)"Testing", (String)("connectionLost: " + cause));
            if (cause != null) {
                FlybitsMQTTService.this.errorConnecting();
            }
        }

        public void messageArrived(final String topic, final MqttMessage message) throws Exception {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Logger.setTag(FlybitsMQTTService._TAG).i(topic + ":" + message.toString());
                    String pushNotification = message.toString();
                    FlybitsMQTTService.this.parseNotification(pushNotification);
                }
            }).start();
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    };
    private BroadcastReceiver mSubscription = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            final ArrayList listOfTopics = intent.getStringArrayListExtra(FlybitsMQTTService.TOPICS);
            final boolean isSubsribe = intent.getBooleanExtra(FlybitsMQTTService.IS_SUBSCRIBE, false);
            Logger.setTag(FlybitsMQTTService._TAG).d("Topic: " + listOfTopics);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (isSubsribe) {
                        FlybitsMQTTService.this.subscribe(listOfTopics);
                    } else {
                        FlybitsMQTTService.this.unsubscribe(listOfTopics);
                    }
                }
            }).start();
        }
    };
    private BroadcastReceiver mDisconnection = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                FlybitsMQTTService.this.disconnect();
            }
            catch (MqttException e) {
                Logger.exception("FlybitsMQTTService.mDisconnection", (Exception)((Object)e));
            }
        }
    };
    private BroadcastReceiver mPublish = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
        }
    };
    private Runnable runnableConnection = new Runnable(){

        @Override
        public void run() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Logger.setTag(FlybitsMQTTService._TAG).d("runnableConnection");
                    FlybitsMQTTService.this.connect();
                }
            }).start();
        }
    };

    public void onCreate() {
        super.onCreate();
        Log.d((String)_TAG, (String)"onCreate");
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d((String)_TAG, (String)"onStartCommand");
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mSubscription, new IntentFilter(MQTT_SUBSCRIBE));
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mDisconnection, new IntentFilter(MQTT_DISCONNECT));
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mPublish, new IntentFilter(MQTT_PUBLISH));
        this.handler = new Handler();
        this.topics = new Vector();
        this.rand = new Random();
        new Thread(new Runnable(){

            @Override
            public void run() {
                FlybitsMQTTService.this.connect();
            }
        }).start();
        return 1;
    }

    private void connect() {
        String projectID = SharedElements.getProjectID(this.getBaseContext());
        String deviceID = SharedElements.getDeviceID(this.getBaseContext());
        String userID = SharedElements.getUserID(this.getBaseContext());
        String jwt = SharedElements.getSavedJWTToken(this.getBaseContext());
        if (jwt == null) {
            jwt = "";
        }
        String MQTT_url = FlybitsAPIConstants.getMQTTURL();
        String clientID = deviceID + "_" + projectID;
        this.client = new MqttAndroidClient(this.getBaseContext(), MQTT_url, clientID);
        try {
            IMqttToken token = this.client.connect(this.getMqttConnectionOptions(jwt, userID, deviceID, projectID));
            if (token != null) {
                token.setActionCallback(new IMqttActionListener(){

                    public void onSuccess(IMqttToken asyncActionToken) {
                        Log.d((String)FlybitsMQTTService._TAG, (String)"Success");
                        FlybitsMQTTService.this.client.setBufferOpts(FlybitsMQTTService.this.getDisconnectedBufferOptions());
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                if (FlybitsMQTTService.this.client.isConnected()) {
                                    FlybitsMQTTService.this.topics.add(SharedElements.getDeviceID(FlybitsMQTTService.this.getBaseContext()) + "_" + SharedElements.getProjectID(FlybitsMQTTService.this.getBaseContext()));
                                    if (FlybitsMQTTService.this.topics.size() > 0) {
                                        ArrayList list = new ArrayList(FlybitsMQTTService.this.topics);
                                        FlybitsMQTTService.this.subscribe(list);
                                        FlybitsMQTTService.this.topics.clear();
                                    }
                                }
                            }
                        }).start();
                    }

                    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                        Log.d((String)FlybitsMQTTService._TAG, (String)("Failure " + exception.toString()));
                        if (exception instanceof MqttException && ((MqttException)exception).getReasonCode() == 4) {
                            final ExecutorService executorService = Executors.newSingleThreadExecutor();
                            executorService.execute(new Runnable(){

                                @Override
                                public void run() {
                                    block2: {
                                        try {
                                            FlyJWT.refreshJWT(FlybitsMQTTService.this.getBaseContext());
                                        }
                                        catch (FlybitsException e) {
                                            Logger.exception("FlybitsMQTTService.connect.onFailure", e);
                                            if (!(e instanceof FlybitsDisabledException) || executorService.isShutdown()) break block2;
                                            FlybitsMQTTService.this.stopSelf();
                                        }
                                    }
                                }
                            });
                        }
                        FlybitsMQTTService.this.errorConnecting();
                    }
                });
            }
        }
        catch (MqttException e) {
            Logger.exception("FlybitsMQTTService.onCreate", (Exception)((Object)e));
        }
        this.client.setCallback((MqttCallback)this.callback);
    }

    private void subscribe(ArrayList<String> listOfTopics) {
        for (String topic : listOfTopics) {
            if (topic.isEmpty()) continue;
            if (this.client != null && this.client.isConnected()) {
                try {
                    this.client.subscribe(topic, 0);
                }
                catch (MqttException e) {
                    Logger.exception("FlybitsMQTTService.subscribe", (Exception)((Object)e));
                }
                continue;
            }
            this.topics.add(topic);
        }
    }

    private void unsubscribe(ArrayList<String> listOfTopics) {
        for (String topic : listOfTopics) {
            if (topic.isEmpty()) continue;
            if (this.client != null && this.client.isConnected()) {
                try {
                    this.client.unsubscribe(topic);
                }
                catch (MqttException e) {
                    Logger.exception("FlybitsMQTTService.subscribe", (Exception)((Object)e));
                }
                continue;
            }
            this.topics.remove(topic);
        }
    }

    private void disconnect() throws MqttException {
        if (this.client != null && this.client.isConnected()) {
            IMqttToken mqttToken = this.client.disconnect();
            mqttToken.setActionCallback(new IMqttActionListener(){

                public void onSuccess(IMqttToken iMqttToken) {
                    Log.d((String)FlybitsMQTTService._TAG, (String)"Successfully disconnected");
                    FlybitsMQTTService.this.client.unregisterResources();
                    FlybitsMQTTService.this.client.close();
                    FlybitsMQTTService.this.client = null;
                    FlybitsMQTTService.this.stopSelf();
                }

                public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
                    Log.d((String)FlybitsMQTTService._TAG, (String)("Failed to disconnected " + throwable.toString()));
                }
            });
        }
    }

    private MqttConnectOptions getMqttConnectionOptions(String jwt, String userID, String deviceID, String projectID) {
        String clientID = deviceID + "_" + projectID;
        String will = userID + "_" + deviceID + "_" + projectID;
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setAutomaticReconnect(true);
        mqttConnectOptions.setCleanSession(false);
        mqttConnectOptions.setUserName(clientID);
        mqttConnectOptions.setPassword(jwt.toCharArray());
        mqttConnectOptions.setKeepAliveInterval(30);
        try {
            mqttConnectOptions.setWill("flybits.mqtt.offline", will.getBytes("UTF-8"), 1, false);
        }
        catch (UnsupportedEncodingException | IllegalStateException e) {
            Logger.exception("FlybitsMQTTService.connect.UnsupportedEncodingException", e);
            return null;
        }
        return mqttConnectOptions;
    }

    @NonNull
    private DisconnectedBufferOptions getDisconnectedBufferOptions() {
        DisconnectedBufferOptions disconnectedBufferOptions = new DisconnectedBufferOptions();
        disconnectedBufferOptions.setBufferEnabled(true);
        disconnectedBufferOptions.setBufferSize(100);
        disconnectedBufferOptions.setPersistBuffer(false);
        disconnectedBufferOptions.setDeleteOldestMessages(false);
        return disconnectedBufferOptions;
    }

    private void parseNotification(String pushNotification) {
        DeserializeMQTTNotification deserializeResult = new DeserializeMQTTNotification();
        PushInternal result = (PushInternal)deserializeResult.fromJson(pushNotification);
        Intent intentCustom = new Intent();
        switch (result.getCategory()) {
            case "kernel": {
                intentCustom.setAction(INTERNAL_FLYBITS_PUSH_SCOPE_KERNEL);
                break;
            }
            case "push": 
            case "custom": {
                intentCustom.setAction(INTERNAL_FLYBITS_PUSH_SCOPE_PUSH);
                break;
            }
            case "context": {
                intentCustom.setAction(INTERNAL_FLYBITS_PUSH_SCOPE_CONTEXT);
            }
        }
        intentCustom.putExtra(INTERNAL_FLYBITS_PUSH_DATA, result.getData());
        intentCustom.putExtra(INTERNAL_FLYBITS_PUSH_ACTION, result.getAction());
        intentCustom.putExtra(INTERNAL_FLYBITS_PUSH_ENTITY, result.getEntity());
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).sendBroadcast(intentCustom);
    }

    private void errorConnecting() {
        Logger.setTag(_TAG).d("errorConnecting");
        this.handler.removeCallbacks(this.runnableConnection);
        if (this.timeout < 256) {
            int randomNumber = this.rand.nextInt(this.timeout * 2) + this.timeout;
            this.handler.postDelayed(this.runnableConnection, (long)(randomNumber * 1000));
            this.timeout *= 2;
        } else {
            this.stopSelf();
        }
    }

    public void onDestroy() {
        Logger.setTag(_TAG).d("onDestroy()");
        this.handler.removeCallbacks(this.runnableConnection);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mSubscription);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mDisconnection);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mPublish);
    }
}

