package com.flybits.internal;

import android.support.annotation.NonNull;

import com.flybits.commons.library.deserializations.IDeserializer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DeserializeMQTTNotification extends IDeserializer<PushInternal> {

    public DeserializeMQTTNotification() {}

    @Override
    public PushInternal fromJson(JSONObject jObj) {
        try{
            String entity       = (!jObj.isNull("entity")) ? jObj.getString("entity") : "unknown";
            String action       = (!jObj.isNull("action")) ? jObj.getString("action") : "unknown";
            String category     = (!jObj.isNull("category")) ? jObj.getString("category") : "unknown";

            String bodyAsString = null;
            if (!jObj.isNull("body")){

                Object jsonType = jObj.get("body");
                if (jsonType instanceof JSONObject) {
                    bodyAsString = jObj.getJSONObject("body").toString();
                }else if (jsonType instanceof JSONArray) {
                    bodyAsString = jObj.getJSONArray("body").toString();
                }else{
                    bodyAsString = jObj.getString("body");
                }
            }
            return new PushInternal(entity, action, category, bodyAsString);
        }catch (JSONException exception){}

        return null;
    }

    @Override
    public PushInternal fromJson(JSONArray jsonArray) {
        return null;
    }

    @Override
    public String toJson(@NonNull PushInternal obj) {
        return "{}";
    }
}
